/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.logmq.process;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BatchRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.sc.base.mqqueue.VankeQueue;
import com.xforceplus.vanke.sc.controller.logmq.process.ReplayLogMqProcess;
import com.xforceplus.vanke.sc.repository.dao.LogMqDao;
import com.xforceplus.vanke.sc.repository.model.LogMqExample;
import com.xforceplus.vanke.sc.utils.QueueSender;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReplayLogMqProcess
extends AbstractProcess<BatchRequest<Long>, Boolean> {
    @Autowired
    private LogMqDao logMqDao;
    @Autowired
    private QueueSender queueSender;
    private List<String> systemQueues = new ArrayList();
    private boolean flag;

    public ReplayLogMqProcess() {
        this.init();
    }

    private void init() {
        try {
            Field[] fields;
            VankeQueue vankeQueue = new VankeQueue();
            for (Field field : fields = vankeQueue.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                this.systemQueues.add((String)field.get(vankeQueue));
            }
            this.flag = true;
        }
        catch (Exception e) {
            this.logger.error("\u521d\u59cb\u5316\u961f\u5217\u5f02\u5e38", (Throwable)e);
            this.flag = false;
        }
    }

    protected CommonResponse<Boolean> process(BatchRequest<Long> request) throws RuntimeException {
        if (!this.flag) {
            this.init();
        }
        if (!this.flag) {
            return CommonResponse.failed((String)"\u961f\u5217\u5f52\u7c7b\u5931\u8d25\uff0c\u65e0\u6cd5\u8c03\u7528\u624b\u5de5\u91cd\u63a8\uff0c\u8bf7\u91cd\u8bd5");
        }
        LogMqExample example = new LogMqExample();
        example.createCriteria().andMqLogIdIn(request.getKeys());
        List entities = this.logMqDao.selectByExample(example);
        entities.forEach(entity -> {
            1 typeReference = new /* Unavailable Anonymous Inner Class!! */;
            try {
                Map properties = (Map)JSON.parseObject((String)entity.getProperties(), (TypeReference)typeReference, (Feature[])new Feature[0]);
                if (this.systemQueues.contains(entity.getQueueName())) {
                    QueueSender.textSend((String)entity.getQueueName(), (String)entity.getMessage(), (Map)properties);
                } else {
                    this.queueSender.send(entity.getQueueName(), entity.getMessage(), properties);
                }
            }
            catch (Exception e) {
                this.logger.error("mq\u91cd\u63a8\u5f02\u5e38", (Throwable)e);
            }
        });
        return CommonResponse.ok((String)"\u6210\u529f", (Object)true);
    }
}

