/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.logoperations.process;

import com.google.common.collect.Lists;
import com.xforceplus.landedestate.basecommon.help.entity.BeanUtils;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.process.response.ListResult;
import com.xforceplus.landedestate.basecommon.vaildate.ValidatorUtil;
import com.xforceplus.vanke.sc.client.model.GetLogOpsListRequest;
import com.xforceplus.vanke.sc.client.model.LogOperationsDTO;
import com.xforceplus.vanke.sc.repository.dao.LogOperationsDao;
import com.xforceplus.vanke.sc.repository.model.LogOperationsExample;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogOperationsListPorcess
extends AbstractProcess<GetLogOpsListRequest, ListResult<LogOperationsDTO>> {
    @Autowired
    private LogOperationsDao logOperationsDao;

    protected CommonResponse<ListResult<LogOperationsDTO>> process(GetLogOpsListRequest request) throws RuntimeException {
        LogOperationsExample logOperationsExample = new LogOperationsExample();
        logOperationsExample.setLimit(request.getRows());
        logOperationsExample.setOffset(request.getOffset());
        logOperationsExample.setOrderByClause("ops_time desc");
        LogOperationsExample.Criteria criteria = logOperationsExample.createCriteria();
        if (ValidatorUtil.isNotEmpty((String)request.getInvoiceCode())) {
            criteria.andInvoiceCodeEqualTo(request.getInvoiceCode());
        }
        if (ValidatorUtil.isNotEmpty((String)request.getInvoiceNo())) {
            criteria.andInvoiceNoEqualTo(request.getInvoiceNo());
        }
        if (ValidatorUtil.isNotEmpty((String)request.getOpsName())) {
            criteria.andOpsNameEqualTo(request.getOpsName());
        }
        if (ValidatorUtil.isNotEmpty((Object)request.getOpsType())) {
            criteria.andOpsTypeEqualTo(request.getOpsType());
        }
        if (ValidatorUtil.isNotEmpty((String)request.getSalesBillNo())) {
            criteria.andSalesbillNoEqualTo(request.getSalesBillNo());
        }
        if (ValidatorUtil.isNotEmpty((Collection)request.getOpsTime()) && request.getOpsTime().size() == 2) {
            criteria.andOpsTimeBetween(new Date((Long)request.getOpsTime().get(0)), new Date((Long)request.getOpsTime().get(1)));
        }
        List logOperationsEntityList = this.logOperationsDao.selectByExample(logOperationsExample);
        ArrayList logOperationsDTOList = Lists.newArrayList();
        logOperationsEntityList.stream().forEach(logOperationsEntity -> {
            LogOperationsDTO logOperationsDTO = new LogOperationsDTO();
            BeanUtils.copyProperties((Object)logOperationsEntity, (Object)logOperationsDTO);
            logOperationsDTOList.add(logOperationsDTO);
        });
        ListResult result = new ListResult(Long.valueOf(this.logOperationsDao.countByExample(logOperationsExample)), logOperationsEntityList.stream().map(entity -> {
            LogOperationsDTO dto = new LogOperationsDTO();
            BeanUtils.copyProperties((Object)entity, (Object)dto);
            return dto;
        }).collect(Collectors.toList()));
        return CommonResponse.ok((String)"\u6210\u529f", (Object)result);
    }
}

