/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.menu.process;

import com.google.common.collect.Lists;
import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.sc.client.model.MenuTreeBean;
import com.xforceplus.vanke.sc.service.MenuBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class GetMenuTreeListProcess
extends AbstractProcess<BaseRequest, List<MenuTreeBean>> {
    @Autowired
    private MenuBusiness menuBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;

    protected CommonResponse<List<MenuTreeBean>> process(BaseRequest request) throws RuntimeException {
        ArrayList resultList = Lists.newArrayList();
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        if (null == userSessionInfo) {
            return CommonResponse.failed((String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5");
        }
        List gxMenuEntityList = this.menuBusiness.getSysMenuList(userSessionInfo);
        if (CollectionUtils.isEmpty((Collection)gxMenuEntityList)) {
            return CommonResponse.failed((String)"\u6ca1\u6709\u627e\u5230\u83dc\u5355\uff0c\u8bf7\u68c0\u67e5\u5f53\u524d\u7528\u6237\u6743\u9650");
        }
        List menuTreeBeanList = this.menuBusiness.setMenuTreeBean(gxMenuEntityList);
        menuTreeBeanList.stream().forEach(item -> {
            if (item.getParentId() == 0L) {
                resultList.add(this.menuBusiness.findChildren(item, menuTreeBeanList));
            }
        });
        return CommonResponse.ok((String)"\u6210\u529f", (Object)resultList);
    }
}

