/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.role.process;

import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.sc.client.model.SaveRoleRequest;
import com.xforceplus.vanke.sc.client.model.SysRoleDTO;
import com.xforceplus.vanke.sc.service.RoleBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SaveRoleProcess
extends AbstractProcess<SaveRoleRequest, List<Long>> {
    @Autowired
    private RoleBusiness roleBusiness;
    @Autowired
    private ContextHolder<UserContext> contextHolder;

    protected void check(SaveRoleRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        if (!((UserContext)this.contextHolder.get()).getUserSessionInfo().getIsAdmin()) {
            throw new ValidationException("\u975e\u7ba1\u7406\u5458\u65e0\u6cd5\u65b0\u589e\u89d2\u8272");
        }
        if (CollectionUtils.isEmpty((Collection)request.getEntities())) {
            throw new ValidationException("\u64cd\u4f5c\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (SysRoleDTO entity : request.getEntities()) {
            this.checkEmpty(entity.getRoleName(), "\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    protected CommonResponse<List<Long>> process(SaveRoleRequest request) throws RuntimeException {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        if (null == userSessionInfo) {
            return CommonResponse.failed((String)"\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5");
        }
        List keys = request.getEntities().stream().map(entity -> {
            int result = this.roleBusiness.insert((SysRoleDTO)entity);
            if (result > 0) {
                if (!CollectionUtils.isEmpty((Collection)entity.getMenuIdList())) {
                    this.roleBusiness.batchInsertRoleMenu(entity.getRoleId(), entity.getMenuIdList(), userSessionInfo);
                }
                return entity.getRoleId();
            }
            return null;
        }).collect(Collectors.toList());
        if (keys.stream().anyMatch(key -> key != null)) {
            if (keys.stream().anyMatch(key -> key == null)) {
                return CommonResponse.ok((String)"\u90e8\u5206\u65b0\u589e\u6210\u529f", keys);
            }
            return CommonResponse.ok((String)"\u65b0\u589e\u6210\u529f", keys);
        }
        return CommonResponse.failed((String)"\u65e0\u8bb0\u5f55\u65b0\u589e");
    }
}

