/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.user;

import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.landedestate.basecommon.process.response.ListResult;
import com.xforceplus.vanke.sc.client.annotation.ApiV1VankeSC;
import com.xforceplus.vanke.sc.client.api.UserApi;
import com.xforceplus.vanke.sc.client.model.GetUserListRequest;
import com.xforceplus.vanke.sc.client.model.SaveUserRequest;
import com.xforceplus.vanke.sc.client.model.SysUserBean;
import com.xforceplus.vanke.sc.client.model.SysUserDTO;
import com.xforceplus.vanke.sc.client.model.UpdatePasswordRequest;
import com.xforceplus.vanke.sc.client.model.UpdateUserRequest;
import com.xforceplus.vanke.sc.client.model.UserLoginRequest;
import com.xforceplus.vanke.sc.controller.BaseController;
import com.xforceplus.vanke.sc.controller.user.dto.LoginResponse;
import com.xforceplus.vanke.sc.controller.user.process.DeleteUserProcess;
import com.xforceplus.vanke.sc.controller.user.process.DisableUserProcess;
import com.xforceplus.vanke.sc.controller.user.process.EnableUserProcess;
import com.xforceplus.vanke.sc.controller.user.process.GetUserDetailProcess;
import com.xforceplus.vanke.sc.controller.user.process.GetUserListProcess;
import com.xforceplus.vanke.sc.controller.user.process.SaveUserProcess;
import com.xforceplus.vanke.sc.controller.user.process.UpdatePasswordProcess;
import com.xforceplus.vanke.sc.controller.user.process.UpdateUserProcess;
import com.xforceplus.vanke.sc.controller.user.process.UserLoginProcess;
import com.xforceplus.xplatsecurity.annotation.SkipAuth;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;

@ApiV1VankeSC
public class UserController
extends BaseController
implements UserApi {
    @Autowired
    private DeleteUserProcess deleteUserProcess;
    @Autowired
    private DisableUserProcess disableUserProcess;
    @Autowired
    private EnableUserProcess enableUserProcess;
    @Autowired
    private GetUserDetailProcess getUserDetailProcess;
    @Autowired
    private GetUserListProcess getUserListProcess;
    @Autowired
    private SaveUserProcess saveUserProcess;
    @Autowired
    private UpdateUserProcess updateUserProcess;
    @Autowired
    private UserLoginProcess userLoginProcess;
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    @Autowired
    private UpdatePasswordProcess updatePasswordProcess;

    public CommonResponse<Boolean> deleteUser(@PathVariable(value="userId") Long userId, @RequestBody BaseRequest request) {
        return this.deleteUserProcess.execute((Object)userId, request);
    }

    public CommonResponse<Boolean> disableUser(@PathVariable(value="userId") Long userId, @RequestBody BaseRequest request) {
        return this.disableUserProcess.execute((Object)userId, request);
    }

    public CommonResponse<Boolean> enableUser(@PathVariable(value="userId") Long userId, @RequestBody BaseRequest request) {
        return this.enableUserProcess.execute((Object)userId, request);
    }

    public CommonResponse<SysUserBean> getUserDetail(@PathVariable(value="userId") Long userId, BaseRequest request) {
        return this.getUserDetailProcess.execute((Object)userId, request);
    }

    public CommonResponse<ListResult<SysUserDTO>> getUserList(GetUserListRequest request) {
        return this.getUserListProcess.execute((BaseRequest)request);
    }

    public CommonResponse<List<Long>> saveUser(@RequestBody SaveUserRequest request) {
        UserSessionInfo userSessionInfo = this.currentUser();
        request.getEntities().forEach(entity -> {
            entity.setCreateTime(Long.valueOf(System.currentTimeMillis()));
            entity.setCreateUserId(Long.valueOf(userSessionInfo.getAccountId()));
            entity.setCreateUserName(userSessionInfo.getSysUserName());
        });
        return this.saveUserProcess.execute((BaseRequest)request);
    }

    public CommonResponse<Boolean> updateUser(@PathVariable(value="userId") Long userId, @RequestBody UpdateUserRequest request) {
        UserSessionInfo userSessionInfo = this.currentUser();
        request.setUpdateTime(Long.valueOf(System.currentTimeMillis()));
        request.setUpdateUserId(Long.valueOf(userSessionInfo.getAccountId()));
        request.setUpdateUserName(userSessionInfo.getSysUserName());
        return this.updateUserProcess.execute((Object)userId, (BaseRequest)request);
    }

    @SkipAuth
    public CommonResponse<LoginResponse> userLogin(@RequestBody UserLoginRequest request) {
        return this.userLoginProcess.execute((BaseRequest)request);
    }

    public Void userLogout() {
        this.contextHolder.clearContext();
        return null;
    }

    public CommonResponse updatePassword(@RequestBody UpdatePasswordRequest updatePassWordRequest) {
        return this.updatePasswordProcess.execute((BaseRequest)updatePassWordRequest);
    }
}

