/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.vanke.sc.controller.user.process;

import com.xforceplus.landedestate.basecommon.process.AbstractProcess;
import com.xforceplus.landedestate.basecommon.process.request.BaseRequest;
import com.xforceplus.landedestate.basecommon.process.response.CommonResponse;
import com.xforceplus.vanke.sc.client.model.UpdatePasswordRequest;
import com.xforceplus.vanke.sc.service.UserBusiness;
import com.xforceplus.xplatsecurity.domain.ContextHolder;
import com.xforceplus.xplatsecurity.domain.UserContext;
import com.xforceplus.xplatsecurity.domain.UserSessionInfo;
import javax.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UpdatePasswordProcess
extends AbstractProcess<UpdatePasswordRequest, Boolean> {
    @Autowired
    private ContextHolder<UserContext> contextHolder;
    @Autowired
    private UserBusiness userBusiness;

    protected void check(UpdatePasswordRequest request) throws ValidationException {
        super.check((BaseRequest)request);
        String rex = "^(?=.*\\d)(?=.*[A-Za-z])[\\x20-\\x7e]{8,}$";
        if (!request.getNewPassword().matches(rex)) {
            throw new ValidationException("\u5bc6\u7801\u5fc5\u987b\u5305\u542b\u5b57\u6bcd\u548c\u6570\u5b57\u4e14\u957f\u5ea6\u5927\u4e8e8\u4f4d\u4ee5\u4e0a");
        }
    }

    protected CommonResponse<Boolean> process(UpdatePasswordRequest request) throws RuntimeException {
        UserSessionInfo userSessionInfo = ((UserContext)this.contextHolder.get()).getUserSessionInfo();
        Long userId = userSessionInfo.getSysUserId();
        this.userBusiness.updatePassword(request, userId);
        return CommonResponse.ok((String)"\u4fee\u6539\u6210\u529f!");
    }
}

