package com.xforceplus.local.ssdp;

import com.alibaba.fastjson.JSONObject;
import lombok.Getter;
import lombok.Setter;

public class SsdpContext extends InheritableThreadLocal<SsdpContext.SsdpHolder> {

    private volatile static SsdpContext instance;

    private SsdpContext() {
    }

    @Override
    protected SsdpHolder initialValue() {
        return new SsdpHolder();
    }

    public static SsdpContext getInstance() {
        if (null == instance) {
            synchronized (SsdpContext.class) {
                if (null == instance) {
                    instance = new SsdpContext();
                }
            }
        }
        return instance;
    }

    public static SsdpHolder current() {
        return getInstance().get();
    }

    public static void clean() {
        getInstance().remove();
    }

    @Setter
    @Getter
    public static class SsdpHolder extends JSONObject {

        Object original;
        String returnCode;
        String returnDesc;
        String returnData;
        Object requestData;

    }

}
