package com.xforceplus.local.ssdp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.crc.openapi.sdk.common.Constants;
import com.xforceplus.local.base.util.XDateUtils;
import lombok.extern.slf4j.Slf4j;

/**
 * SSDP工具
 */
@Slf4j
public class SsdpUtils {

    /**
     * 返回JSON格式
     *
     * @param returnCode
     * @param returnDesc
     * @param returnData
     * @return
     */
    public static JSONObject toReturnData(Object returnCode, Object returnDesc, Object returnData) {
        return new JSONObject()
                .fluentPut(Constants.RESPONSE,
                        new JSONObject()
                                .fluentPut(Constants.RETURN_CODE, returnCode)
                                .fluentPut(Constants.RETURN_DESC, returnDesc)
                                .fluentPut(Constants.RETURN_DATA, returnData)
                                .fluentPut(Constants.RETURN_STAMP, getTimeStamp()));
    }

    public static String getTimeStamp() {
        return XDateUtils.format("yyyy-MM-dd HH:mm:ss:SSS");
    }

    public static Object extractRequestData(String ssdpJson) {
        return extractRequestData(JSON.parse(ssdpJson));
    }

    public static Object extractRequestData(Object orgiJson) {
        return extractRequestData(orgiJson, Constants.REQUEST, Constants.REQUEST_DATA, "BUS_DATA");

    }

    private static Object extractRequestData(Object orgiJson, String... keys) {
        for (String key : keys) {
            if (orgiJson instanceof JSONObject) {
                if (((JSONObject) orgiJson).containsKey(key)) {
                    orgiJson = ((JSONObject) orgiJson).get(key);
                }
            }
        }
        return orgiJson;
    }

}
