package com.xforceplus.local.ssdp.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.xforceplus.local.base.json.BigDecimalValueFilter;
import com.xforceplus.local.ssdp.service.SsdpRequestDataConverter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Slf4j
@Configuration
public class SsdpHandleConfig {

    @Bean
    @ConditionalOnMissingBean(SsdpRequestDataConverter.class)
    public SsdpRequestDataConverter ssdpRequestDataConverter(ObjectProvider<SerializeFilter[]> filters) {
        final SerializeFilter[] serializeFilters = filters.getIfAvailable();
        return (ssdpTable, requestData) -> JSON.toJSONString(requestData, serializeFilters);
    }

    @Bean
    public BigDecimalValueFilter bigDecimalValueFilter() {
        return new BigDecimalValueFilter();
    }

}
