package com.xforceplus.local.ssdp.config;

import com.xforceplus.local.ssdp.domain.SsdpTable;
import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Map;

@Slf4j
@Setter
@Getter
@Configuration
@ConfigurationProperties(prefix = "local.ssdp")
public class SsdpTableConfig implements InitializingBean {

    private Map<String, SsdpTable[]> config;

    public SsdpTable[] getSsdpTable(String ssdpName) {
        if (this.config == null) {
            return null;
        }
        return this.config.get(ssdpName);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.config != null) {
            this.config.forEach((name, config) -> {
                for (SsdpTable ssdpTable : config) {
                    if (StringUtils.isBlank(ssdpTable.getApiId())) {
                        log.warn("Ssdp config [{}] - ApiId is null, please configure", name);
                    } else {
                        log.debug("Ssdp config [{}] - {}", name, ssdpTable.getApiId());
                    }
                }
            });
        }
    }

}
