package com.xforceplus.local.ssdp.service;

import org.springframework.core.Ordered;
import org.springframework.core.annotation.AliasFor;
import org.springframework.core.annotation.Order;

import java.lang.annotation.*;

@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Order
public @interface SsdpResult {

    /**
     * 服务编码
     *
     * @return
     */
    @AliasFor(value = "apiId")
    String value() default "*";

    /**
     * 服务编码
     *
     * @return
     */
    @AliasFor(value = "value")
    String apiId() default "*";

    /**
     * 服务版本
     *
     * @return
     */
    String apiVersion() default "*";

    /**
     * Alias for {@link Order#value}.
     */
    @AliasFor(annotation = Order.class, attribute = "value")
    int orderId() default Ordered.LOWEST_PRECEDENCE;

}
