package com.xforceplus.local.ssdp.service.impl;

import com.crc.openapi.sdk.entity.Result;
import com.xforceplus.local.base.json.JsonUtils;
import com.xforceplus.local.base.retry.XRetriableException;
import com.xforceplus.local.base.util.XResult;
import com.xforceplus.local.ssdp.SsdpContext;
import com.xforceplus.local.ssdp.config.SsdpRetryConfig;
import com.xforceplus.local.ssdp.domain.SsdpTable;
import com.xforceplus.local.ssdp.service.SsdpResult;
import com.xforceplus.local.ssdp.service.SsdpResultHandler;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Set;

@Slf4j
@Component
@SsdpResult
public class DefaultSsdpResultHandler implements SsdpResultHandler {

    @Autowired
    private SsdpRetryConfig ssdpRetryConfig;

    @Override
    public XResult convert(SsdpTable ssdpTable, Result result) {
        final String original = result.getOriginal();
        final String returnCode = result.getReturnCode();
        final String returnDesc = result.getReturnDesc();
        final String returnData = result.getReturnData();
        SsdpContext.current().setReturnCode(returnCode);
        SsdpContext.current().setReturnDesc(returnDesc);
        SsdpContext.current().setReturnData(returnData);
        // SsdpContext.current().setOriginal(original);
        final Set<String> returnCodes = this.ssdpRetryConfig.getReturnCodes();
        XResult xResult = XResult.of(returnCode, returnDesc, returnData).setOriginal(original);
        if (returnCodes.contains(returnCode)) {
            log.debug("Ssdp[returnCode] is contains, to retry [{}] -> {}", returnCode, returnCodes);
            throw new XRetriableException(xResult);
        }
        // 处理返回的结果
        xResult = this.handleSsdpResult(result, xResult);
        // 处理返回的数据
        if (StringUtils.isNotBlank(returnData)) {
            xResult = this.handleReturnData(result, xResult);
        }
        //
        return xResult;
    }

    /**
     * 处理返回的结果
     *
     * @param result
     * @param xResult
     */
    protected XResult handleSsdpResult(Result result, XResult xResult) {
        final String returnCode = result.getReturnCode();
        if (returnCode != null && returnCode.startsWith("S0")) {
            xResult = XResult.ok();
        } else {
            if (this.ssdpRetryConfig.getReturnCodes().isEmpty()) {
                log.debug("Ssdp[returnCode] isn't contains, to retry -> {}", returnCode);
                throw new XRetriableException(xResult);
            }
        }
        return xResult;
    }

    /**
     * 处理返回的数据
     *
     * @param result
     * @param xResult
     */
    protected XResult handleReturnData(Result result, XResult xResult) {
        final String returnData = result.getReturnData();
        xResult = JsonUtils.parseObject(returnData, XResult.class).orElseGet(() -> XResult.fail(returnData));
        if (!xResult.containsKey(XResult.CODE)) {
            xResult.setCode(XResult.FAILURE_CODE);
        }
        return xResult;
    }

}
