package com.xforceplus.local.ssdp.service.impl;

import com.crc.openapi.sdk.entity.Result;
import com.xforceplus.local.base.util.XResult;
import com.xforceplus.local.ssdp.service.SsdpResult;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;

/**
 * 影像的SSDP返回值处理器
 */
@Slf4j
@Component
@ConditionalOnExpression("#{environment.containsProperty('" + ImageSsdpResultHandler.IMAGE_VERIFY_RESULT_API_ID + "')}")
@SsdpResult("${" + ImageSsdpResultHandler.IMAGE_VERIFY_RESULT_API_ID + "}")
public class ImageSsdpResultHandler extends DefaultSsdpResultHandler {

    public static final String IMAGE_VERIFY_RESULT_API_ID = "local.ssdp.config.verifyResult[0].apiId";

    @Override
    protected XResult handleReturnData(Result result, XResult xResult) {
        xResult = super.handleReturnData(result, xResult);
        // 影像的返回值 {"result":"0","success":"","items":[{"result":"0","success":"","serviceid":"1","errormsg":""}],"errormsg":""}
        if (xResult.containsKey("result")) {
            Object retrs = xResult.remove("result");
            if (retrs instanceof String) {
                if (StringUtils.isNotBlank((String) retrs)) {
                    if ("0".equals(retrs)) {
                        xResult.setCode(XResult.SUCCESS_CODE);
                    } else if ("1".equals(retrs)) {
                        xResult.setCode(XResult.FAILURE_CODE);
                    } else {
                        xResult.setCode((String) retrs);
                    }
                }
            } else {
                if (retrs != null) {
                    xResult.setData(retrs);
                }
            }
        }
        if (xResult.containsKey("errormsg")) {
            String errormsg = (String) xResult.remove("errormsg");
            if (StringUtils.isNotBlank(errormsg)) {
                xResult.setMsg(errormsg);
            }
        }
        if (xResult.containsKey("items")) {
            xResult.setData(xResult.remove("items"));
        }
        //
        return xResult;
    }

}
