package com.xforceplus.local.ssdp.service.impl;

import com.crc.openapi.sdk.client.SysClient;
import com.crc.openapi.sdk.common.CommonEnum;
import com.crc.openapi.sdk.entity.ApiCommonParameter;
import com.crc.openapi.sdk.entity.Result;
import com.xforceplus.local.base.logging.ApiLog;
import com.xforceplus.local.ssdp.SsdpUtils;
import com.xforceplus.local.ssdp.domain.SsdpTable;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.Properties;

@Slf4j
@Component
public class SsdpSysClient {

    /**
     * 调用SSDP客户端（记录日志）
     *
     * @param ssdpTable
     * @param requestData
     * @return
     */
    @ApiLog(value = "SSDP@#{#p0.apiId}[#{#p0.apiVersion}]", include = {1})
    public Result doPost(SsdpTable ssdpTable, String requestData) {
        // SysClient Properties
        Properties props = this.toProperties(ssdpTable);
        // ApiCommonParameter
        ApiCommonParameter parameter = this.toParameter(ssdpTable);
        // 2020-04-14 APPID 默认subId @TODO
        if (StringUtils.isBlank(parameter.getAppID())) {
            parameter.setAppID(parameter.getAppSubId());
        }
        parameter.setRequestDate(requestData);
        //
        SysClient sClient = new SysClient(props);
        String apiId = ssdpTable.getApiId();
        log.debug("Ssdp starting[{}] - {}", apiId, parameter);
        Result result = sClient.post(parameter);//SSDP接口调用 START
        log.debug("Ssdp completed[{}] - {}", apiId, result);
        return result;
    }

    private Properties toProperties(SsdpTable ssdpTable) {
        Properties props = new Properties();
        props.setProperty("order", ssdpTable.getChainOrder().name());
        props.setProperty("http.ip", ssdpTable.getHttpId());
        props.setProperty("model", ssdpTable.getServerType().name());
        props.setProperty("gateway", ssdpTable.getGatewayType().name());
        props.setProperty("method", "POST");
        return props;
    }

    private ApiCommonParameter toParameter(SsdpTable ssdpTable) {
        ApiCommonParameter parameter = new ApiCommonParameter();
        parameter.setApiID(StringUtils.trimToEmpty(ssdpTable.getApiId()));
        parameter.setApiVersion(StringUtils.trimToEmpty(ssdpTable.getApiVersion()));
        parameter.setAppSubId(StringUtils.trimToEmpty(ssdpTable.getAppSubId()));
        parameter.setAppToken(StringUtils.trimToEmpty(ssdpTable.getAppToken()));
        parameter.setPartnerID(StringUtils.trimToEmpty(ssdpTable.getPartnerId()));
        parameter.setSignSecret(StringUtils.trimToEmpty(ssdpTable.getSignSecret()));
        parameter.setSysID(StringUtils.trimToEmpty(ssdpTable.getSysId()));
        CommonEnum.SignMethodEnum signMethod = ssdpTable.getSignMethod();
        if (CommonEnum.SignMethodEnum.RSA.equals(signMethod)) {
            parameter.setPrivateKey(StringUtils.trimToEmpty(ssdpTable.getPrivateKey()));
        }
        parameter.setSignMethod(signMethod);
        // 如果调用的api需要DES加密，则设置DES加密的秘钥
        CommonEnum.ChainOrderEnum chainOrder = ssdpTable.getChainOrder();
        if (chainOrder.equals(CommonEnum.ChainOrderEnum.SIGN_FIRST) || chainOrder.equals(CommonEnum.ChainOrderEnum.DES_FIRST)) {
            parameter.setMsgSecret(StringUtils.trimToEmpty(ssdpTable.getMsgSecret()));
        }
        parameter.setTimeStamp(SsdpUtils.getTimeStamp());
        return parameter;
    }

}
