package com.xforceplus.local.ssdp.servlet;

import com.crc.openapi.sdk.common.Constants;
import org.springframework.core.annotation.AliasFor;

import java.lang.annotation.*;

@Target({ElementType.METHOD, ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Ssdp {

    /**
     * 名称
     *
     * @return
     */
    @AliasFor(value = "name")
    String value() default "";

    /**
     * 名称
     *
     * @return
     */
    @AliasFor(value = "value")
    String name() default "";

    /**
     * 默认的成功的SSDP编码
     *
     * @return
     */
    String successCode() default "${local.servlet.ssdp.constants.successCode:" + Constants.SUCEEESS_S0A00000 + "}";

    /**
     * 默认的成功的SSDP描述
     *
     * @return
     */
    String successDesc() default "${local.servlet.ssdp.constants.successDesc:成功}";

    /**
     * 默认的失败的SSDP编码Constants.ERROR_MSG_E0MI0003
     *
     * @return
     */
    String failureCode() default "${local.servlet.ssdp.constants.failureCode:" + Constants.SUCEEESS_E0S00002 + "}";

    /**
     * 默认的失败的消息
     *
     * @return
     */
    String failureDesc() default "${local.servlet.ssdp.constants.failureDesc:请求成功}";

}