package com.xforceplus.local.ssdp.servlet;

import com.xforceplus.local.base.util.SpringUtils;
import com.xforceplus.local.base.util.XFieldUtils;
import com.xforceplus.local.base.util.XResult;
import com.xforceplus.local.ssdp.SsdpContext;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Slf4j
@Aspect
@Component
@Order(SsdpAspect.ORDERED_PRECEDENCE)
public class SsdpAspect {

    public static final int ORDERED_PRECEDENCE = Ordered.LOWEST_PRECEDENCE - 20;

    @Around("@annotation(ssdp)")
    public Object around(ProceedingJoinPoint proceedingJoinPoint, Ssdp ssdp) throws Throwable {
        Object retval;
        Logger logger = XFieldUtils.getLogger(proceedingJoinPoint).orElse(log);
        try {
            retval = proceedingJoinPoint.proceed();
        } catch (Throwable e) {
            logger.error("Ssdp failure - {}", e.getLocalizedMessage(), e);
            SsdpContext.current().setReturnCode(SpringUtils.resolveStringValue(ssdp.failureCode()));
            SsdpContext.current().setReturnDesc(SpringUtils.resolveStringValue(ssdp.failureDesc()));
            retval = XResult.fail(SsdpContext.current().getReturnDesc());
        }
        return retval;
    }

}
