package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 发票开具控制项
 */
@ApiModel(description = "发票开具控制项")

@JsonInclude(NON_NULL)
public class InvoiceControlInfo {
  @JsonProperty("isBlockChain")
  private Boolean isBlockChain = false;

  @JsonProperty("templateVersion")
  private String templateVersion = null;

  @JsonIgnore
  public InvoiceControlInfo isBlockChain(Boolean isBlockChain) {
    this.isBlockChain = isBlockChain;
    return this;
  }

   /**
   * 是否是区块链发票 <默认不是区块链>
   * @return isBlockChain
  **/


  @ApiModelProperty(value = "是否是区块链发票 <默认不是区块链>")
  public Boolean IsBlockChain() {
    return isBlockChain;
  }

  public void setIsBlockChain(Boolean isBlockChain) {
    this.isBlockChain = isBlockChain;
  }

  @JsonIgnore
  public InvoiceControlInfo templateVersion(String templateVersion) {
    this.templateVersion = templateVersion;
    return this;
  }

   /**
   * 版式文件版本 (0-使用5行模版, 1-使用8行模版，无值等同0)
   * @return templateVersion
  **/


  @ApiModelProperty(value = "版式文件版本 (0-使用5行模版, 1-使用8行模版，无值等同0)")
  public String getTemplateVersion() {
    return templateVersion;
  }

  public void setTemplateVersion(String templateVersion) {
    this.templateVersion = templateVersion;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceControlInfo invoiceControlInfo = (InvoiceControlInfo) o;
    return Objects.equals(this.isBlockChain, invoiceControlInfo.isBlockChain) &&
        Objects.equals(this.templateVersion, invoiceControlInfo.templateVersion);
  }

  @Override
  public int hashCode() {
    return Objects.hash(isBlockChain, templateVersion);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceControlInfo {\n");
    
    sb.append("    isBlockChain: ").append(toIndentedString(isBlockChain)).append("\n");
    sb.append("    templateVersion: ").append(toIndentedString(templateVersion)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
