package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 购方信息
 */
@ApiModel(description = "购方信息")

@JsonInclude(NON_NULL)
public class PurchaserInfo {
  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("purchaserAddressAndTel")
  private String purchaserAddressAndTel = null;

  @JsonProperty("purchaserBankInfo")
  private String purchaserBankInfo = null;

  @JsonProperty("purchaserEPayId")
  private String purchaserEPayId = null;

  @JsonIgnore
  public PurchaserInfo purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方名称(最大长度不超过200个字符)
   * @return purchaserName
  **/


  @ApiModelProperty(value = "购方名称(最大长度不超过200个字符)")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public PurchaserInfo purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方税号(最大长度不超过20个字符)
   * @return purchaserTaxNo
  **/


  @ApiModelProperty(value = "购方税号(最大长度不超过20个字符)")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public PurchaserInfo purchaserAddressAndTel(String purchaserAddressAndTel) {
    this.purchaserAddressAndTel = purchaserAddressAndTel;
    return this;
  }

   /**
   * 购方地址、电话
   * @return purchaserAddressAndTel
  **/


  @ApiModelProperty(value = "购方地址、电话")
  public String getPurchaserAddressAndTel() {
    return purchaserAddressAndTel;
  }

  public void setPurchaserAddressAndTel(String purchaserAddressAndTel) {
    this.purchaserAddressAndTel = purchaserAddressAndTel;
  }

  @JsonIgnore
  public PurchaserInfo purchaserBankInfo(String purchaserBankInfo) {
    this.purchaserBankInfo = purchaserBankInfo;
    return this;
  }

   /**
   * 购方开户行及其账号
   * @return purchaserBankInfo
  **/


  @ApiModelProperty(value = "购方开户行及其账号")
  public String getPurchaserBankInfo() {
    return purchaserBankInfo;
  }

  public void setPurchaserBankInfo(String purchaserBankInfo) {
    this.purchaserBankInfo = purchaserBankInfo;
  }

  @JsonIgnore
  public PurchaserInfo purchaserEPayId(String purchaserEPayId) {
    this.purchaserEPayId = purchaserEPayId;
    return this;
  }

   /**
   * 购方电子支付标识
   * @return purchaserEPayId
  **/


  @ApiModelProperty(value = "购方电子支付标识")
  public String getPurchaserEPayId() {
    return purchaserEPayId;
  }

  public void setPurchaserEPayId(String purchaserEPayId) {
    this.purchaserEPayId = purchaserEPayId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PurchaserInfo purchaserInfo = (PurchaserInfo) o;
    return Objects.equals(this.purchaserName, purchaserInfo.purchaserName) &&
        Objects.equals(this.purchaserTaxNo, purchaserInfo.purchaserTaxNo) &&
        Objects.equals(this.purchaserAddressAndTel, purchaserInfo.purchaserAddressAndTel) &&
        Objects.equals(this.purchaserBankInfo, purchaserInfo.purchaserBankInfo) &&
        Objects.equals(this.purchaserEPayId, purchaserInfo.purchaserEPayId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(purchaserName, purchaserTaxNo, purchaserAddressAndTel, purchaserBankInfo, purchaserEPayId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PurchaserInfo {\n");
    
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    purchaserAddressAndTel: ").append(toIndentedString(purchaserAddressAndTel)).append("\n");
    sb.append("    purchaserBankInfo: ").append(toIndentedString(purchaserBankInfo)).append("\n");
    sb.append("    purchaserEPayId: ").append(toIndentedString(purchaserEPayId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
