package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.cherry.contract.model.RedNotificationDataInfo;
import com.xforceplus.micro.tax.cherry.contract.model.ResponseHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * RedNotificationDownloadResultResponse
 */

@JsonInclude(NON_NULL)
public class RedNotificationDownloadResultResponse {
  @JsonProperty("head")
  private ResponseHead head = null;

  @JsonProperty("requestSerialNo")
  private String requestSerialNo = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("redDataInfoList")
  private List<RedNotificationDataInfo> redDataInfoList = new ArrayList<>();

  @JsonIgnore
  public RedNotificationDownloadResultResponse head(ResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 红字信息表下载结果标准响应头(返回代码:负数：表示失败 0:表示处理中，1:表示处理完成 )
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "红字信息表下载结果标准响应头(返回代码:负数：表示失败 0:表示处理中，1:表示处理完成 )")
  public ResponseHead getHead() {
    return head;
  }

  public void setHead(ResponseHead head) {
    this.head = head;
  }

  @JsonIgnore
  public RedNotificationDownloadResultResponse requestSerialNo(String requestSerialNo) {
    this.requestSerialNo = requestSerialNo;
    return this;
  }

   /**
   * 请求流水号,唯一标志
   * @return requestSerialNo
  **/


  @ApiModelProperty(value = "请求流水号,唯一标志")
  public String getRequestSerialNo() {
    return requestSerialNo;
  }

  public void setRequestSerialNo(String requestSerialNo) {
    this.requestSerialNo = requestSerialNo;
  }

  @JsonIgnore
  public RedNotificationDownloadResultResponse companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 申请方公司税号
   * @return companyTaxNo
  **/


  @ApiModelProperty(value = "申请方公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public RedNotificationDownloadResultResponse redDataInfoList(List<RedNotificationDataInfo> redDataInfoList) {
    this.redDataInfoList = redDataInfoList;
    return this;
  }

  public RedNotificationDownloadResultResponse addRedDataInfoListItem(RedNotificationDataInfo redDataInfoListItem) {
    this.redDataInfoList.add(redDataInfoListItem);
    return this;
  }

   /**
   * 红字信息表信息
   * @return redDataInfoList
  **/

  @Valid

  @ApiModelProperty(value = "红字信息表信息")
  public List<RedNotificationDataInfo> getRedDataInfoList() {
    return redDataInfoList;
  }

  public void setRedDataInfoList(List<RedNotificationDataInfo> redDataInfoList) {
    this.redDataInfoList = redDataInfoList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RedNotificationDownloadResultResponse redNotificationDownloadResultResponse = (RedNotificationDownloadResultResponse) o;
    return Objects.equals(this.head, redNotificationDownloadResultResponse.head) &&
        Objects.equals(this.requestSerialNo, redNotificationDownloadResultResponse.requestSerialNo) &&
        Objects.equals(this.companyTaxNo, redNotificationDownloadResultResponse.companyTaxNo) &&
        Objects.equals(this.redDataInfoList, redNotificationDownloadResultResponse.redDataInfoList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, requestSerialNo, companyTaxNo, redDataInfoList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RedNotificationDownloadResultResponse {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    requestSerialNo: ").append(toIndentedString(requestSerialNo)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    redDataInfoList: ").append(toIndentedString(redDataInfoList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
