package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 发票打印控制项
 */
@ApiModel(description = "发票打印控制项")

@JsonInclude(NON_NULL)
public class InvoicePrintControlInfo {
  @JsonProperty("template")
  private String template = "0";

  @JsonProperty("customPrintInfo")
  private Map<String, String> customPrintInfo = new HashMap<>();

  @JsonProperty("saleListPrintFlag")
  private Boolean saleListPrintFlag = false;

  @JsonIgnore
  public InvoicePrintControlInfo template(String template) {
    this.template = template;
    return this;
  }

   /**
   * 版式(1:订制版式【取自定义内容中key为:head1和head2，二个值，打印在发票左上方】)
   * @return template
  **/


  @ApiModelProperty(value = "版式(1:订制版式【取自定义内容中key为:head1和head2，二个值，打印在发票左上方】)")
  public String getTemplate() {
    return template;
  }

  public void setTemplate(String template) {
    this.template = template;
  }

  @JsonIgnore
  public InvoicePrintControlInfo customPrintInfo(Map<String, String> customPrintInfo) {
    this.customPrintInfo = customPrintInfo;
    return this;
  }

  public InvoicePrintControlInfo putCustomPrintInfoItem(String key, String customPrintInfoItem) {
    this.customPrintInfo.put(key, customPrintInfoItem);
    return this;
  }

   /**
   * 订制内容
   * @return customPrintInfo
  **/


  @ApiModelProperty(value = "订制内容")
  public Map<String, String> getCustomPrintInfo() {
    return customPrintInfo;
  }

  public void setCustomPrintInfo(Map<String, String> customPrintInfo) {
    this.customPrintInfo = customPrintInfo;
  }

  @JsonIgnore
  public InvoicePrintControlInfo saleListPrintFlag(Boolean saleListPrintFlag) {
    this.saleListPrintFlag = saleListPrintFlag;
    return this;
  }

   /**
   * 销货清单打印标志 (默认：不打印)
   * @return saleListPrintFlag
  **/


  @ApiModelProperty(value = "销货清单打印标志 (默认：不打印)")
  public Boolean SaleListPrintFlag() {
    return saleListPrintFlag;
  }

  public void setSaleListPrintFlag(Boolean saleListPrintFlag) {
    this.saleListPrintFlag = saleListPrintFlag;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoicePrintControlInfo invoicePrintControlInfo = (InvoicePrintControlInfo) o;
    return Objects.equals(this.template, invoicePrintControlInfo.template) &&
        Objects.equals(this.customPrintInfo, invoicePrintControlInfo.customPrintInfo) &&
        Objects.equals(this.saleListPrintFlag, invoicePrintControlInfo.saleListPrintFlag);
  }

  @Override
  public int hashCode() {
    return Objects.hash(template, customPrintInfo, saleListPrintFlag);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoicePrintControlInfo {\n");
    
    sb.append("    template: ").append(toIndentedString(template)).append("\n");
    sb.append("    customPrintInfo: ").append(toIndentedString(customPrintInfo)).append("\n");
    sb.append("    saleListPrintFlag: ").append(toIndentedString(saleListPrintFlag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
