package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 发票领购明细信息
 */
@ApiModel(description = "发票领购明细信息")

@JsonInclude(NON_NULL)
public class InvoiceStockDetail {
  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceBeginNo")
  private String invoiceBeginNo = null;

  @JsonProperty("invoiceEndNo")
  private String invoiceEndNo = null;

  @JsonProperty("invoiceNum")
  private String invoiceNum = null;

  @JsonProperty("residualNum")
  private String residualNum = null;

  @JsonProperty("receiveDate")
  private String receiveDate = null;

  @JsonProperty("receivePerson")
  private String receivePerson = null;

  @JsonIgnore
  public InvoiceStockDetail invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/


  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public InvoiceStockDetail invoiceBeginNo(String invoiceBeginNo) {
    this.invoiceBeginNo = invoiceBeginNo;
    return this;
  }

   /**
   * 发票起始号码
   * @return invoiceBeginNo
  **/


  @ApiModelProperty(value = "发票起始号码")
  public String getInvoiceBeginNo() {
    return invoiceBeginNo;
  }

  public void setInvoiceBeginNo(String invoiceBeginNo) {
    this.invoiceBeginNo = invoiceBeginNo;
  }

  @JsonIgnore
  public InvoiceStockDetail invoiceEndNo(String invoiceEndNo) {
    this.invoiceEndNo = invoiceEndNo;
    return this;
  }

   /**
   * 发票终止号码
   * @return invoiceEndNo
  **/


  @ApiModelProperty(value = "发票终止号码")
  public String getInvoiceEndNo() {
    return invoiceEndNo;
  }

  public void setInvoiceEndNo(String invoiceEndNo) {
    this.invoiceEndNo = invoiceEndNo;
  }

  @JsonIgnore
  public InvoiceStockDetail invoiceNum(String invoiceNum) {
    this.invoiceNum = invoiceNum;
    return this;
  }

   /**
   * 发票份数
   * @return invoiceNum
  **/


  @ApiModelProperty(value = "发票份数")
  public String getInvoiceNum() {
    return invoiceNum;
  }

  public void setInvoiceNum(String invoiceNum) {
    this.invoiceNum = invoiceNum;
  }

  @JsonIgnore
  public InvoiceStockDetail residualNum(String residualNum) {
    this.residualNum = residualNum;
    return this;
  }

   /**
   * 剩余份数
   * @return residualNum
  **/


  @ApiModelProperty(value = "剩余份数")
  public String getResidualNum() {
    return residualNum;
  }

  public void setResidualNum(String residualNum) {
    this.residualNum = residualNum;
  }

  @JsonIgnore
  public InvoiceStockDetail receiveDate(String receiveDate) {
    this.receiveDate = receiveDate;
    return this;
  }

   /**
   * 领购日期
   * @return receiveDate
  **/


  @ApiModelProperty(value = "领购日期")
  public String getReceiveDate() {
    return receiveDate;
  }

  public void setReceiveDate(String receiveDate) {
    this.receiveDate = receiveDate;
  }

  @JsonIgnore
  public InvoiceStockDetail receivePerson(String receivePerson) {
    this.receivePerson = receivePerson;
    return this;
  }

   /**
   * 领购人员
   * @return receivePerson
  **/


  @ApiModelProperty(value = "领购人员")
  public String getReceivePerson() {
    return receivePerson;
  }

  public void setReceivePerson(String receivePerson) {
    this.receivePerson = receivePerson;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceStockDetail invoiceStockDetail = (InvoiceStockDetail) o;
    return Objects.equals(this.invoiceCode, invoiceStockDetail.invoiceCode) &&
        Objects.equals(this.invoiceBeginNo, invoiceStockDetail.invoiceBeginNo) &&
        Objects.equals(this.invoiceEndNo, invoiceStockDetail.invoiceEndNo) &&
        Objects.equals(this.invoiceNum, invoiceStockDetail.invoiceNum) &&
        Objects.equals(this.residualNum, invoiceStockDetail.residualNum) &&
        Objects.equals(this.receiveDate, invoiceStockDetail.receiveDate) &&
        Objects.equals(this.receivePerson, invoiceStockDetail.receivePerson);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceCode, invoiceBeginNo, invoiceEndNo, invoiceNum, residualNum, receiveDate, receivePerson);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceStockDetail {\n");
    
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceBeginNo: ").append(toIndentedString(invoiceBeginNo)).append("\n");
    sb.append("    invoiceEndNo: ").append(toIndentedString(invoiceEndNo)).append("\n");
    sb.append("    invoiceNum: ").append(toIndentedString(invoiceNum)).append("\n");
    sb.append("    residualNum: ").append(toIndentedString(residualNum)).append("\n");
    sb.append("    receiveDate: ").append(toIndentedString(receiveDate)).append("\n");
    sb.append("    receivePerson: ").append(toIndentedString(receivePerson)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
