package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.cherry.contract.model.GeneratePDFRedInfo;
import com.xforceplus.micro.tax.cherry.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * GenerateRedNotificationPDFRequest
 */

@JsonInclude(NON_NULL)
public class GenerateRedNotificationPDFRequest {
  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("generatePDFRedInfo")
  private GeneratePDFRedInfo generatePDFRedInfo = null;

  @JsonIgnore
  public GenerateRedNotificationPDFRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public GenerateRedNotificationPDFRequest generatePDFRedInfo(GeneratePDFRedInfo generatePDFRedInfo) {
    this.generatePDFRedInfo = generatePDFRedInfo;
    return this;
  }

   /**
   * 生成PDF红字信息
   * @return generatePDFRedInfo
  **/

  @Valid

  @ApiModelProperty(value = "生成PDF红字信息")
  public GeneratePDFRedInfo getGeneratePDFRedInfo() {
    return generatePDFRedInfo;
  }

  public void setGeneratePDFRedInfo(GeneratePDFRedInfo generatePDFRedInfo) {
    this.generatePDFRedInfo = generatePDFRedInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GenerateRedNotificationPDFRequest generateRedNotificationPDFRequest = (GenerateRedNotificationPDFRequest) o;
    return Objects.equals(this.head, generateRedNotificationPDFRequest.head) &&
        Objects.equals(this.generatePDFRedInfo, generateRedNotificationPDFRequest.generatePDFRedInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, generatePDFRedInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GenerateRedNotificationPDFRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    generatePDFRedInfo: ").append(toIndentedString(generatePDFRedInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
