package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.cherry.contract.model.ReceiveBackInfo;
import com.xforceplus.micro.tax.cherry.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * ReceiveBackRequest
 */

@JsonInclude(NON_NULL)
public class ReceiveBackRequest {
  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("receiveInfo")
  private ReceiveBackInfo receiveInfo = null;

  @JsonIgnore
  public ReceiveBackRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public ReceiveBackRequest receiveInfo(ReceiveBackInfo receiveInfo) {
    this.receiveInfo = receiveInfo;
    return this;
  }

   /**
   * 发票领购退回信息
   * @return receiveInfo
  **/

  @Valid

  @ApiModelProperty(value = "发票领购退回信息")
  public ReceiveBackInfo getReceiveInfo() {
    return receiveInfo;
  }

  public void setReceiveInfo(ReceiveBackInfo receiveInfo) {
    this.receiveInfo = receiveInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ReceiveBackRequest receiveBackRequest = (ReceiveBackRequest) o;
    return Objects.equals(this.head, receiveBackRequest.head) &&
        Objects.equals(this.receiveInfo, receiveBackRequest.receiveInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, receiveInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ReceiveBackRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    receiveInfo: ").append(toIndentedString(receiveInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
