package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.cherry.contract.model.RedNotificationInfo;
import com.xforceplus.micro.tax.cherry.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * RedNotificationApplyRequest
 */

@JsonInclude(NON_NULL)
public class RedNotificationApplyRequest {
  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("redInfo")
  private RedNotificationInfo redInfo = null;

  @JsonIgnore
  public RedNotificationApplyRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public RedNotificationApplyRequest redInfo(RedNotificationInfo redInfo) {
    this.redInfo = redInfo;
    return this;
  }

   /**
   * 申请红字信息
   * @return redInfo
  **/

  @Valid

  @ApiModelProperty(value = "申请红字信息")
  public RedNotificationInfo getRedInfo() {
    return redInfo;
  }

  public void setRedInfo(RedNotificationInfo redInfo) {
    this.redInfo = redInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RedNotificationApplyRequest redNotificationApplyRequest = (RedNotificationApplyRequest) o;
    return Objects.equals(this.head, redNotificationApplyRequest.head) &&
        Objects.equals(this.redInfo, redNotificationApplyRequest.redInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, redInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RedNotificationApplyRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    redInfo: ").append(toIndentedString(redInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
