package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.cherry.contract.model.InvoiceStockDetail;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 发票领购信息
 */
@ApiModel(description = "发票领购信息")

@JsonInclude(NON_NULL)
public class ReceiveInfo {
  @JsonProperty("coreTerminalNo")
  private String coreTerminalNo = null;

  @JsonProperty("terminalNo")
  private String terminalNo = null;

  @JsonProperty("nextInvoiceCode")
  private String nextInvoiceCode = null;

  @JsonProperty("nextInvoiceNo")
  private String nextInvoiceNo = null;

  @JsonProperty("invoiceStockNum")
  private String invoiceStockNum = null;

  @JsonProperty("invoiceStockDetail")
  private List<InvoiceStockDetail> invoiceStockDetail = new ArrayList<>();

  @JsonIgnore
  public ReceiveInfo coreTerminalNo(String coreTerminalNo) {
    this.coreTerminalNo = coreTerminalNo;
    return this;
  }

   /**
   * 税控服务器编号序列:一个税控多个核心板序
   * @return coreTerminalNo
  **/


  @ApiModelProperty(value = "税控服务器编号序列:一个税控多个核心板序")
  public String getCoreTerminalNo() {
    return coreTerminalNo;
  }

  public void setCoreTerminalNo(String coreTerminalNo) {
    this.coreTerminalNo = coreTerminalNo;
  }

  @JsonIgnore
  public ReceiveInfo terminalNo(String terminalNo) {
    this.terminalNo = terminalNo;
    return this;
  }

   /**
   * 税控服务器编号
   * @return terminalNo
  **/


  @ApiModelProperty(value = "税控服务器编号")
  public String getTerminalNo() {
    return terminalNo;
  }

  public void setTerminalNo(String terminalNo) {
    this.terminalNo = terminalNo;
  }

  @JsonIgnore
  public ReceiveInfo nextInvoiceCode(String nextInvoiceCode) {
    this.nextInvoiceCode = nextInvoiceCode;
    return this;
  }

   /**
   * 当前未开发票代码
   * @return nextInvoiceCode
  **/


  @ApiModelProperty(value = "当前未开发票代码")
  public String getNextInvoiceCode() {
    return nextInvoiceCode;
  }

  public void setNextInvoiceCode(String nextInvoiceCode) {
    this.nextInvoiceCode = nextInvoiceCode;
  }

  @JsonIgnore
  public ReceiveInfo nextInvoiceNo(String nextInvoiceNo) {
    this.nextInvoiceNo = nextInvoiceNo;
    return this;
  }

   /**
   * 当前未开发票号码
   * @return nextInvoiceNo
  **/


  @ApiModelProperty(value = "当前未开发票号码")
  public String getNextInvoiceNo() {
    return nextInvoiceNo;
  }

  public void setNextInvoiceNo(String nextInvoiceNo) {
    this.nextInvoiceNo = nextInvoiceNo;
  }

  @JsonIgnore
  public ReceiveInfo invoiceStockNum(String invoiceStockNum) {
    this.invoiceStockNum = invoiceStockNum;
    return this;
  }

   /**
   * 总剩余份数
   * @return invoiceStockNum
  **/


  @ApiModelProperty(value = "总剩余份数")
  public String getInvoiceStockNum() {
    return invoiceStockNum;
  }

  public void setInvoiceStockNum(String invoiceStockNum) {
    this.invoiceStockNum = invoiceStockNum;
  }

  @JsonIgnore
  public ReceiveInfo invoiceStockDetail(List<InvoiceStockDetail> invoiceStockDetail) {
    this.invoiceStockDetail = invoiceStockDetail;
    return this;
  }

  public ReceiveInfo addInvoiceStockDetailItem(InvoiceStockDetail invoiceStockDetailItem) {
    this.invoiceStockDetail.add(invoiceStockDetailItem);
    return this;
  }

   /**
   * 明细信息
   * @return invoiceStockDetail
  **/

  @Valid

  @ApiModelProperty(value = "明细信息")
  public List<InvoiceStockDetail> getInvoiceStockDetail() {
    return invoiceStockDetail;
  }

  public void setInvoiceStockDetail(List<InvoiceStockDetail> invoiceStockDetail) {
    this.invoiceStockDetail = invoiceStockDetail;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ReceiveInfo receiveInfo = (ReceiveInfo) o;
    return Objects.equals(this.coreTerminalNo, receiveInfo.coreTerminalNo) &&
        Objects.equals(this.terminalNo, receiveInfo.terminalNo) &&
        Objects.equals(this.nextInvoiceCode, receiveInfo.nextInvoiceCode) &&
        Objects.equals(this.nextInvoiceNo, receiveInfo.nextInvoiceNo) &&
        Objects.equals(this.invoiceStockNum, receiveInfo.invoiceStockNum) &&
        Objects.equals(this.invoiceStockDetail, receiveInfo.invoiceStockDetail);
  }

  @Override
  public int hashCode() {
    return Objects.hash(coreTerminalNo, terminalNo, nextInvoiceCode, nextInvoiceNo, invoiceStockNum, invoiceStockDetail);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ReceiveInfo {\n");
    
    sb.append("    coreTerminalNo: ").append(toIndentedString(coreTerminalNo)).append("\n");
    sb.append("    terminalNo: ").append(toIndentedString(terminalNo)).append("\n");
    sb.append("    nextInvoiceCode: ").append(toIndentedString(nextInvoiceCode)).append("\n");
    sb.append("    nextInvoiceNo: ").append(toIndentedString(nextInvoiceNo)).append("\n");
    sb.append("    invoiceStockNum: ").append(toIndentedString(invoiceStockNum)).append("\n");
    sb.append("    invoiceStockDetail: ").append(toIndentedString(invoiceStockDetail)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
