package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.cherry.contract.model.RedNotificationDetail;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 红字信息表信息
 */
@ApiModel(description = "红字信息表信息")

@JsonInclude(NON_NULL)
public class RedNotificationDataInfo {
  @JsonProperty("requestBillNo")
  private String requestBillNo = null;

  @JsonProperty("redNotificationNo")
  private String redNotificationNo = null;

  @JsonProperty("redNotificationType")
  private String redNotificationType = null;

  @JsonProperty("orignInvoiceCode")
  private String orignInvoiceCode = null;

  @JsonProperty("orignInvoiceNo")
  private String orignInvoiceNo = null;

  @JsonProperty("isMutiRate")
  private String isMutiRate = null;

  @JsonProperty("date")
  private String date = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("purchaseTaxNo")
  private String purchaseTaxNo = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("amountWithoutTax")
  private String amountWithoutTax = null;

  @JsonProperty("amountWithTax")
  private String amountWithTax = null;

  @JsonProperty("taxRate")
  private String taxRate = null;

  @JsonProperty("taxAmount")
  private String taxAmount = null;

  @JsonProperty("requestMemo")
  private String requestMemo = null;

  @JsonProperty("goodsNoVer")
  private String goodsNoVer = null;

  @JsonProperty("redNotificationDetail")
  private List<RedNotificationDetail> redNotificationDetail = new ArrayList<>();

  @JsonIgnore
  public RedNotificationDataInfo requestBillNo(String requestBillNo) {
    this.requestBillNo = requestBillNo;
    return this;
  }

   /**
   * 申请单编号
   * @return requestBillNo
  **/


  @ApiModelProperty(value = "申请单编号")
  public String getRequestBillNo() {
    return requestBillNo;
  }

  public void setRequestBillNo(String requestBillNo) {
    this.requestBillNo = requestBillNo;
  }

  @JsonIgnore
  public RedNotificationDataInfo redNotificationNo(String redNotificationNo) {
    this.redNotificationNo = redNotificationNo;
    return this;
  }

   /**
   * 信息表编号
   * @return redNotificationNo
  **/


  @ApiModelProperty(value = "信息表编号")
  public String getRedNotificationNo() {
    return redNotificationNo;
  }

  public void setRedNotificationNo(String redNotificationNo) {
    this.redNotificationNo = redNotificationNo;
  }

  @JsonIgnore
  public RedNotificationDataInfo redNotificationType(String redNotificationType) {
    this.redNotificationType = redNotificationType;
    return this;
  }

   /**
   * 信息表类型：0-正常  1-逾期
   * @return redNotificationType
  **/


  @ApiModelProperty(value = "信息表类型：0-正常  1-逾期")
  public String getRedNotificationType() {
    return redNotificationType;
  }

  public void setRedNotificationType(String redNotificationType) {
    this.redNotificationType = redNotificationType;
  }

  @JsonIgnore
  public RedNotificationDataInfo orignInvoiceCode(String orignInvoiceCode) {
    this.orignInvoiceCode = orignInvoiceCode;
    return this;
  }

   /**
   * 对应蓝字发票代码
   * @return orignInvoiceCode
  **/


  @ApiModelProperty(value = "对应蓝字发票代码")
  public String getOrignInvoiceCode() {
    return orignInvoiceCode;
  }

  public void setOrignInvoiceCode(String orignInvoiceCode) {
    this.orignInvoiceCode = orignInvoiceCode;
  }

  @JsonIgnore
  public RedNotificationDataInfo orignInvoiceNo(String orignInvoiceNo) {
    this.orignInvoiceNo = orignInvoiceNo;
    return this;
  }

   /**
   * 对应蓝字发票号码
   * @return orignInvoiceNo
  **/


  @ApiModelProperty(value = "对应蓝字发票号码")
  public String getOrignInvoiceNo() {
    return orignInvoiceNo;
  }

  public void setOrignInvoiceNo(String orignInvoiceNo) {
    this.orignInvoiceNo = orignInvoiceNo;
  }

  @JsonIgnore
  public RedNotificationDataInfo isMutiRate(String isMutiRate) {
    this.isMutiRate = isMutiRate;
    return this;
  }

   /**
   * 多税率标识 0-一票一税率  1-一票多税率
   * @return isMutiRate
  **/


  @ApiModelProperty(value = "多税率标识 0-一票一税率  1-一票多税率")
  public String getIsMutiRate() {
    return isMutiRate;
  }

  public void setIsMutiRate(String isMutiRate) {
    this.isMutiRate = isMutiRate;
  }

  @JsonIgnore
  public RedNotificationDataInfo date(String date) {
    this.date = date;
    return this;
  }

   /**
   * 填开日期
   * @return date
  **/


  @ApiModelProperty(value = "填开日期")
  public String getDate() {
    return date;
  }

  public void setDate(String date) {
    this.date = date;
  }

  @JsonIgnore
  public RedNotificationDataInfo purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方名称
   * @return purchaserName
  **/


  @ApiModelProperty(value = "购方名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public RedNotificationDataInfo purchaseTaxNo(String purchaseTaxNo) {
    this.purchaseTaxNo = purchaseTaxNo;
    return this;
  }

   /**
   * 购方税号
   * @return purchaseTaxNo
  **/


  @ApiModelProperty(value = "购方税号")
  public String getPurchaseTaxNo() {
    return purchaseTaxNo;
  }

  public void setPurchaseTaxNo(String purchaseTaxNo) {
    this.purchaseTaxNo = purchaseTaxNo;
  }

  @JsonIgnore
  public RedNotificationDataInfo sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

   /**
   * 销方名称
   * @return sellerName
  **/


  @ApiModelProperty(value = "销方名称")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public RedNotificationDataInfo sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 销方税号
   * @return sellerTaxNo
  **/


  @ApiModelProperty(value = "销方税号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public RedNotificationDataInfo amountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额
   * @return amountWithoutTax
  **/


  @ApiModelProperty(value = "不含税金额")
  public String getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public RedNotificationDataInfo amountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 含税金额
   * @return amountWithTax
  **/


  @ApiModelProperty(value = "含税金额")
  public String getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public RedNotificationDataInfo taxRate(String taxRate) {
    this.taxRate = taxRate;
    return this;
  }

   /**
   * 税率:多税率时为空
   * @return taxRate
  **/


  @ApiModelProperty(value = "税率:多税率时为空")
  public String getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(String taxRate) {
    this.taxRate = taxRate;
  }

  @JsonIgnore
  public RedNotificationDataInfo taxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/


  @ApiModelProperty(value = "税额")
  public String getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public RedNotificationDataInfo requestMemo(String requestMemo) {
    this.requestMemo = requestMemo;
    return this;
  }

   /**
   * 申请说明
   * @return requestMemo
  **/


  @ApiModelProperty(value = "申请说明")
  public String getRequestMemo() {
    return requestMemo;
  }

  public void setRequestMemo(String requestMemo) {
    this.requestMemo = requestMemo;
  }

  @JsonIgnore
  public RedNotificationDataInfo goodsNoVer(String goodsNoVer) {
    this.goodsNoVer = goodsNoVer;
    return this;
  }

   /**
   * 编码版本号
   * @return goodsNoVer
  **/


  @ApiModelProperty(value = "编码版本号")
  public String getGoodsNoVer() {
    return goodsNoVer;
  }

  public void setGoodsNoVer(String goodsNoVer) {
    this.goodsNoVer = goodsNoVer;
  }

  @JsonIgnore
  public RedNotificationDataInfo redNotificationDetail(List<RedNotificationDetail> redNotificationDetail) {
    this.redNotificationDetail = redNotificationDetail;
    return this;
  }

  public RedNotificationDataInfo addRedNotificationDetailItem(RedNotificationDetail redNotificationDetailItem) {
    this.redNotificationDetail.add(redNotificationDetailItem);
    return this;
  }

   /**
   * 红字信息表明细
   * @return redNotificationDetail
  **/

  @Valid

  @ApiModelProperty(value = "红字信息表明细")
  public List<RedNotificationDetail> getRedNotificationDetail() {
    return redNotificationDetail;
  }

  public void setRedNotificationDetail(List<RedNotificationDetail> redNotificationDetail) {
    this.redNotificationDetail = redNotificationDetail;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RedNotificationDataInfo redNotificationDataInfo = (RedNotificationDataInfo) o;
    return Objects.equals(this.requestBillNo, redNotificationDataInfo.requestBillNo) &&
        Objects.equals(this.redNotificationNo, redNotificationDataInfo.redNotificationNo) &&
        Objects.equals(this.redNotificationType, redNotificationDataInfo.redNotificationType) &&
        Objects.equals(this.orignInvoiceCode, redNotificationDataInfo.orignInvoiceCode) &&
        Objects.equals(this.orignInvoiceNo, redNotificationDataInfo.orignInvoiceNo) &&
        Objects.equals(this.isMutiRate, redNotificationDataInfo.isMutiRate) &&
        Objects.equals(this.date, redNotificationDataInfo.date) &&
        Objects.equals(this.purchaserName, redNotificationDataInfo.purchaserName) &&
        Objects.equals(this.purchaseTaxNo, redNotificationDataInfo.purchaseTaxNo) &&
        Objects.equals(this.sellerName, redNotificationDataInfo.sellerName) &&
        Objects.equals(this.sellerTaxNo, redNotificationDataInfo.sellerTaxNo) &&
        Objects.equals(this.amountWithoutTax, redNotificationDataInfo.amountWithoutTax) &&
        Objects.equals(this.amountWithTax, redNotificationDataInfo.amountWithTax) &&
        Objects.equals(this.taxRate, redNotificationDataInfo.taxRate) &&
        Objects.equals(this.taxAmount, redNotificationDataInfo.taxAmount) &&
        Objects.equals(this.requestMemo, redNotificationDataInfo.requestMemo) &&
        Objects.equals(this.goodsNoVer, redNotificationDataInfo.goodsNoVer) &&
        Objects.equals(this.redNotificationDetail, redNotificationDataInfo.redNotificationDetail);
  }

  @Override
  public int hashCode() {
    return Objects.hash(requestBillNo, redNotificationNo, redNotificationType, orignInvoiceCode, orignInvoiceNo, isMutiRate, date, purchaserName, purchaseTaxNo, sellerName, sellerTaxNo, amountWithoutTax, amountWithTax, taxRate, taxAmount, requestMemo, goodsNoVer, redNotificationDetail);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RedNotificationDataInfo {\n");
    
    sb.append("    requestBillNo: ").append(toIndentedString(requestBillNo)).append("\n");
    sb.append("    redNotificationNo: ").append(toIndentedString(redNotificationNo)).append("\n");
    sb.append("    redNotificationType: ").append(toIndentedString(redNotificationType)).append("\n");
    sb.append("    orignInvoiceCode: ").append(toIndentedString(orignInvoiceCode)).append("\n");
    sb.append("    orignInvoiceNo: ").append(toIndentedString(orignInvoiceNo)).append("\n");
    sb.append("    isMutiRate: ").append(toIndentedString(isMutiRate)).append("\n");
    sb.append("    date: ").append(toIndentedString(date)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    purchaseTaxNo: ").append(toIndentedString(purchaseTaxNo)).append("\n");
    sb.append("    sellerName: ").append(toIndentedString(sellerName)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    taxRate: ").append(toIndentedString(taxRate)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    requestMemo: ").append(toIndentedString(requestMemo)).append("\n");
    sb.append("    goodsNoVer: ").append(toIndentedString(goodsNoVer)).append("\n");
    sb.append("    redNotificationDetail: ").append(toIndentedString(redNotificationDetail)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
