package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.cherry.contract.model.RedNotificationDownloadInfo;
import com.xforceplus.micro.tax.cherry.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * RedNotificationDownloadRequest
 */

@JsonInclude(NON_NULL)
public class RedNotificationDownloadRequest {
  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("redNotificationDownloadInfo")
  private RedNotificationDownloadInfo redNotificationDownloadInfo = null;

  @JsonIgnore
  public RedNotificationDownloadRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public RedNotificationDownloadRequest redNotificationDownloadInfo(RedNotificationDownloadInfo redNotificationDownloadInfo) {
    this.redNotificationDownloadInfo = redNotificationDownloadInfo;
    return this;
  }

   /**
   * 红字信息表下载信息
   * @return redNotificationDownloadInfo
  **/

  @Valid

  @ApiModelProperty(value = "红字信息表下载信息")
  public RedNotificationDownloadInfo getRedNotificationDownloadInfo() {
    return redNotificationDownloadInfo;
  }

  public void setRedNotificationDownloadInfo(RedNotificationDownloadInfo redNotificationDownloadInfo) {
    this.redNotificationDownloadInfo = redNotificationDownloadInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RedNotificationDownloadRequest redNotificationDownloadRequest = (RedNotificationDownloadRequest) o;
    return Objects.equals(this.head, redNotificationDownloadRequest.head) &&
        Objects.equals(this.redNotificationDownloadInfo, redNotificationDownloadRequest.redNotificationDownloadInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, redNotificationDownloadInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RedNotificationDownloadRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    redNotificationDownloadInfo: ").append(toIndentedString(redNotificationDownloadInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
