package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 红字信息表同步字段信息
 */
@ApiModel(description = "红字信息表同步字段信息")

@JsonInclude(NON_NULL)
public class RedSyncInfo {
  @JsonProperty("requestSerialNo")
  private String requestSerialNo = null;

  @JsonProperty("cloud")
  private String cloud = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("machineCode")
  private String machineCode = null;

  @JsonProperty("overdueStatus")
  private String overdueStatus = null;

  @JsonProperty("startDate")
  private String startDate = null;

  @JsonProperty("endDate")
  private String endDate = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("redNotificationNo")
  private String redNotificationNo = null;

  @JsonProperty("downloadRange")
  private String downloadRange = null;

  @JsonIgnore
  public RedSyncInfo requestSerialNo(String requestSerialNo) {
    this.requestSerialNo = requestSerialNo;
    return this;
  }

   /**
   * 请求流水号,唯一标志
   * @return requestSerialNo
  **/


  @ApiModelProperty(value = "请求流水号,唯一标志")
  public String getRequestSerialNo() {
    return requestSerialNo;
  }

  public void setRequestSerialNo(String requestSerialNo) {
    this.requestSerialNo = requestSerialNo;
  }

  @JsonIgnore
  public RedSyncInfo cloud(String cloud) {
    this.cloud = cloud;
    return this;
  }

   /**
   * 云服务[ac-阿里云提供服务 tc-腾讯云提供服务]
   * @return cloud
  **/


  @ApiModelProperty(value = "云服务[ac-阿里云提供服务 tc-腾讯云提供服务]")
  public String getCloud() {
    return cloud;
  }

  public void setCloud(String cloud) {
    this.cloud = cloud;
  }

  @JsonIgnore
  public RedSyncInfo companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/


  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public RedSyncInfo machineCode(String machineCode) {
    this.machineCode = machineCode;
    return this;
  }

   /**
   * 开票机号
   * @return machineCode
  **/


  @ApiModelProperty(value = "开票机号")
  public String getMachineCode() {
    return machineCode;
  }

  public void setMachineCode(String machineCode) {
    this.machineCode = machineCode;
  }

  @JsonIgnore
  public RedSyncInfo overdueStatus(String overdueStatus) {
    this.overdueStatus = overdueStatus;
    return this;
  }

   /**
   * 逾期状态 N-未逾期 Y-逾期 百旺单机时，该参数无效
   * @return overdueStatus
  **/


  @ApiModelProperty(value = "逾期状态 N-未逾期 Y-逾期 百旺单机时，该参数无效")
  public String getOverdueStatus() {
    return overdueStatus;
  }

  public void setOverdueStatus(String overdueStatus) {
    this.overdueStatus = overdueStatus;
  }

  @JsonIgnore
  public RedSyncInfo startDate(String startDate) {
    this.startDate = startDate;
    return this;
  }

   /**
   * 填开起始日期：请求下载的红字信息表范围
   * @return startDate
  **/


  @ApiModelProperty(value = "填开起始日期：请求下载的红字信息表范围")
  public String getStartDate() {
    return startDate;
  }

  public void setStartDate(String startDate) {
    this.startDate = startDate;
  }

  @JsonIgnore
  public RedSyncInfo endDate(String endDate) {
    this.endDate = endDate;
    return this;
  }

   /**
   * 填开终止日期：请求下载的红字信息表范围
   * @return endDate
  **/


  @ApiModelProperty(value = "填开终止日期：请求下载的红字信息表范围")
  public String getEndDate() {
    return endDate;
  }

  public void setEndDate(String endDate) {
    this.endDate = endDate;
  }

  @JsonIgnore
  public RedSyncInfo purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方税号：百旺单机时，该参数无效
   * @return purchaserTaxNo
  **/


  @ApiModelProperty(value = "购方税号：百旺单机时，该参数无效")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public RedSyncInfo sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 销方税号：百旺单机时，该参数无效
   * @return sellerTaxNo
  **/


  @ApiModelProperty(value = "销方税号：百旺单机时，该参数无效")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public RedSyncInfo redNotificationNo(String redNotificationNo) {
    this.redNotificationNo = redNotificationNo;
    return this;
  }

   /**
   * 信息表编号
   * @return redNotificationNo
  **/


  @ApiModelProperty(value = "信息表编号")
  public String getRedNotificationNo() {
    return redNotificationNo;
  }

  public void setRedNotificationNo(String redNotificationNo) {
    this.redNotificationNo = redNotificationNo;
  }

  @JsonIgnore
  public RedSyncInfo downloadRange(String downloadRange) {
    this.downloadRange = downloadRange;
    return this;
  }

   /**
   * 信息表下载范围：0-全部 1-销方申请 2-购方申请 百旺单机时，该参数无效
   * @return downloadRange
  **/


  @ApiModelProperty(value = "信息表下载范围：0-全部 1-销方申请 2-购方申请 百旺单机时，该参数无效")
  public String getDownloadRange() {
    return downloadRange;
  }

  public void setDownloadRange(String downloadRange) {
    this.downloadRange = downloadRange;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RedSyncInfo redSyncInfo = (RedSyncInfo) o;
    return Objects.equals(this.requestSerialNo, redSyncInfo.requestSerialNo) &&
        Objects.equals(this.cloud, redSyncInfo.cloud) &&
        Objects.equals(this.companyTaxNo, redSyncInfo.companyTaxNo) &&
        Objects.equals(this.machineCode, redSyncInfo.machineCode) &&
        Objects.equals(this.overdueStatus, redSyncInfo.overdueStatus) &&
        Objects.equals(this.startDate, redSyncInfo.startDate) &&
        Objects.equals(this.endDate, redSyncInfo.endDate) &&
        Objects.equals(this.purchaserTaxNo, redSyncInfo.purchaserTaxNo) &&
        Objects.equals(this.sellerTaxNo, redSyncInfo.sellerTaxNo) &&
        Objects.equals(this.redNotificationNo, redSyncInfo.redNotificationNo) &&
        Objects.equals(this.downloadRange, redSyncInfo.downloadRange);
  }

  @Override
  public int hashCode() {
    return Objects.hash(requestSerialNo, cloud, companyTaxNo, machineCode, overdueStatus, startDate, endDate, purchaserTaxNo, sellerTaxNo, redNotificationNo, downloadRange);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RedSyncInfo {\n");
    
    sb.append("    requestSerialNo: ").append(toIndentedString(requestSerialNo)).append("\n");
    sb.append("    cloud: ").append(toIndentedString(cloud)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    machineCode: ").append(toIndentedString(machineCode)).append("\n");
    sb.append("    overdueStatus: ").append(toIndentedString(overdueStatus)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    redNotificationNo: ").append(toIndentedString(redNotificationNo)).append("\n");
    sb.append("    downloadRange: ").append(toIndentedString(downloadRange)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
