package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.cherry.contract.model.InvoiceAmountInfo;
import com.xforceplus.micro.tax.cherry.contract.model.InvoicePrintDetailInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 待打印销货清单信息
 */
@ApiModel(description = "待打印销货清单信息")

@JsonInclude(NON_NULL)
public class SalesListPrintInfo {
  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceDate")
  private String invoiceDate = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("amountInfo")
  private InvoiceAmountInfo amountInfo = null;

  @JsonProperty("details")
  private List<InvoicePrintDetailInfo> details = new ArrayList<>();

  @JsonIgnore
  public SalesListPrintInfo purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方名称(最大长度不超过200个字符)
   * @return purchaserName
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "购方名称(最大长度不超过200个字符)")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public SalesListPrintInfo sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

   /**
   * 销方名称(最大长度不超过200个字符)
   * @return sellerName
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "销方名称(最大长度不超过200个字符)")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public SalesListPrintInfo invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public SalesListPrintInfo invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public SalesListPrintInfo invoiceDate(String invoiceDate) {
    this.invoiceDate = invoiceDate;
    return this;
  }

   /**
   * 开票日期(yyyyMMdd)
   * @return invoiceDate
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "开票日期(yyyyMMdd)")
  public String getInvoiceDate() {
    return invoiceDate;
  }

  public void setInvoiceDate(String invoiceDate) {
    this.invoiceDate = invoiceDate;
  }

  @JsonIgnore
  public SalesListPrintInfo remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 备注
   * @return remark
  **/


  @ApiModelProperty(value = "备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public SalesListPrintInfo amountInfo(InvoiceAmountInfo amountInfo) {
    this.amountInfo = amountInfo;
    return this;
  }

   /**
   * 合计金额信息
   * @return amountInfo
  **/
  @NotNull

  @Valid

  @ApiModelProperty(required = true, value = "合计金额信息")
  public InvoiceAmountInfo getAmountInfo() {
    return amountInfo;
  }

  public void setAmountInfo(InvoiceAmountInfo amountInfo) {
    this.amountInfo = amountInfo;
  }

  @JsonIgnore
  public SalesListPrintInfo details(List<InvoicePrintDetailInfo> details) {
    this.details = details;
    return this;
  }

  public SalesListPrintInfo addDetailsItem(InvoicePrintDetailInfo detailsItem) {
    this.details.add(detailsItem);
    return this;
  }

   /**
   * 发票明细
   * @return details
  **/
  @NotNull

  @Valid

  @ApiModelProperty(required = true, value = "发票明细")
  public List<InvoicePrintDetailInfo> getDetails() {
    return details;
  }

  public void setDetails(List<InvoicePrintDetailInfo> details) {
    this.details = details;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SalesListPrintInfo salesListPrintInfo = (SalesListPrintInfo) o;
    return Objects.equals(this.purchaserName, salesListPrintInfo.purchaserName) &&
        Objects.equals(this.sellerName, salesListPrintInfo.sellerName) &&
        Objects.equals(this.invoiceNo, salesListPrintInfo.invoiceNo) &&
        Objects.equals(this.invoiceCode, salesListPrintInfo.invoiceCode) &&
        Objects.equals(this.invoiceDate, salesListPrintInfo.invoiceDate) &&
        Objects.equals(this.remark, salesListPrintInfo.remark) &&
        Objects.equals(this.amountInfo, salesListPrintInfo.amountInfo) &&
        Objects.equals(this.details, salesListPrintInfo.details);
  }

  @Override
  public int hashCode() {
    return Objects.hash(purchaserName, sellerName, invoiceNo, invoiceCode, invoiceDate, remark, amountInfo, details);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SalesListPrintInfo {\n");
    
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    sellerName: ").append(toIndentedString(sellerName)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceDate: ").append(toIndentedString(invoiceDate)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    amountInfo: ").append(toIndentedString(amountInfo)).append("\n");
    sb.append("    details: ").append(toIndentedString(details)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
