package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 销方信息
 */
@ApiModel(description = "销方信息")

@JsonInclude(NON_NULL)
public class SellerInfo {
  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("sellerAddressAndTel")
  private String sellerAddressAndTel = null;

  @JsonProperty("sellerBankInfo")
  private String sellerBankInfo = null;

  @JsonIgnore
  public SellerInfo sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

   /**
   * 销方名称(最大长度不超过200个字符)
   * @return sellerName
  **/


  @ApiModelProperty(value = "销方名称(最大长度不超过200个字符)")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public SellerInfo sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 销方税号(最大长度不超过20个字符)
   * @return sellerTaxNo
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "销方税号(最大长度不超过20个字符)")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public SellerInfo sellerAddressAndTel(String sellerAddressAndTel) {
    this.sellerAddressAndTel = sellerAddressAndTel;
    return this;
  }

   /**
   * 销方地址、电话
   * @return sellerAddressAndTel
  **/


  @ApiModelProperty(value = "销方地址、电话")
  public String getSellerAddressAndTel() {
    return sellerAddressAndTel;
  }

  public void setSellerAddressAndTel(String sellerAddressAndTel) {
    this.sellerAddressAndTel = sellerAddressAndTel;
  }

  @JsonIgnore
  public SellerInfo sellerBankInfo(String sellerBankInfo) {
    this.sellerBankInfo = sellerBankInfo;
    return this;
  }

   /**
   * 销方开户行及其账号
   * @return sellerBankInfo
  **/


  @ApiModelProperty(value = "销方开户行及其账号")
  public String getSellerBankInfo() {
    return sellerBankInfo;
  }

  public void setSellerBankInfo(String sellerBankInfo) {
    this.sellerBankInfo = sellerBankInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SellerInfo sellerInfo = (SellerInfo) o;
    return Objects.equals(this.sellerName, sellerInfo.sellerName) &&
        Objects.equals(this.sellerTaxNo, sellerInfo.sellerTaxNo) &&
        Objects.equals(this.sellerAddressAndTel, sellerInfo.sellerAddressAndTel) &&
        Objects.equals(this.sellerBankInfo, sellerInfo.sellerBankInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sellerName, sellerTaxNo, sellerAddressAndTel, sellerBankInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SellerInfo {\n");
    
    sb.append("    sellerName: ").append(toIndentedString(sellerName)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    sellerAddressAndTel: ").append(toIndentedString(sellerAddressAndTel)).append("\n");
    sb.append("    sellerBankInfo: ").append(toIndentedString(sellerBankInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
