package com.xforceplus.micro.tax.cherry.contract.model.vatv2;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.BaseResponseDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.terminal.TerminalDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 发票申领
 *
 * @author zhouwen
 * @date 2020-04-01
 */
public class InvoiceApplyMessage {

    @Data
    public static class Request {

        /**
         * 终端服务器信息
         */
        private TerminalDto terminalDto;

        /**
         * 发票类型代码
         */
        private String invoiceType;

        /**
         * 发票种类代码
         */
        private String invoiceKind;

        /**
         * 申领数量
         */
        private String applyCount;

        /**
         * 申领时间(yyyy-MM-dd HH:mm:ss)
         */
        private String applyTime;

        /**
         * 证件类型
         */
        private String certificateType;

        /**
         * 证件号码
         */
        private String certificateNum;

        /**
         * 经办人姓名
         */
        private String operator;

        /**
         * 申领方式：1-自行领取; 2-快递配送
         */
        private String applyWay;

        /**
         * 申领说明
         */
        private String applyExplain;

        /**
         * 配送信息
         */
        private DeliveryDTO deliveryDTO;
    }

    /**
     * 配送信息
     */
    @Data
    public static class DeliveryDTO {

        /**
         * 收件人姓名
         */
        private String recipientName;

        /**
         * 收件人地址
         */
        private String recipientAddress;

        /**
         * 移动电话
         */
        private String mobilePhone;

        /**
         * 固定电话
         */
        private String telephone;

        /**
         * 邮编
         */
        private String zipCode;

        /**
         * 备注
         */
        private String remark;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        /**
         * 申领序号
         */
        private String applySeq;
    }

}
