package com.xforceplus.micro.tax.cherry.contract.model.vatv2;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.BaseResponseDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.terminal.TerminalDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 发票申领准备信息
 *
 * @author zhouwen
 * @date 2020-04-02
 */
public class InvoiceApplyPrepareMessage {

    @Data
    public static class Request {

        /**
         * 终端服务器信息
         */
        private TerminalDto terminalDto;

        /**
         * 税号
         */
        private String taxCode;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        /**
         * 纳税人识别号
         */
        private String taxCode;

        /**
         * 虚拟设备号
         */
        private String deviceNo;

        /**
         * 收件人信息
         */
        private List<Recipient> recipientList;

        /**
         * 经办人信息
         */
        private List<Operator> operatorList;

        /**
         * 发票核定信息
         */
        private List<InvoiceCheck> invoiceCheckList;

    }

    /**
     * 收件人信息
     */
    @Data
    public static class Recipient {

        /**
         * 名称
         */
        private String name;

        /**
         * 地址
         */
        private String address;

        /**
         * 移动电话
         */
        private String mobilePhone;

        /**
         * 固定电话
         */
        private String telephone;

        /**
         * 邮编
         */
        private String zipCode;

        /**
         * 备注信息
         */
        private String remark;
    }

    /**
     * 经办人信息
     */
    @Data
    public static class Operator {

        /**
         * 经办人姓名
         */
        private String operatorName;

        /**
         * 证件类型
         */
        private String credentialType;

        /**
         * 证件号码
         */
        private String credentialNo;

    }

    @Data
    public static class InvoiceCheck {

        /**
         * 发票种类代码
         */
        private String invoiceKind;

        /**
         * 发票种类名称
         */
        private String invoiceKindName;

        /**
         * 发票类型代码
         */
        private String invoiceType;

        /**
         * 每次购票限额
         */
        private String amountTimeLimit;

        /**
         * 每月购票限额
         */
        private String amountMonthLimit;

        /**
         * 最高持票量
         */
        private String maxHolds;
    }
}
