package com.xforceplus.micro.tax.cherry.contract.model.vatv2;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.BaseResponseDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.terminal.TerminalDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 发票申领撤销
 *
 * @author zhouwen
 * @date 2020-04-01
 */
public class InvoiceApplyRevokeMessage {

    @Data
    public static class Request {

        /**
         * 终端服务器信息
         */
        private TerminalDto terminalDto;

        /**
         * 申领序号
         */
        private String applySeq;
    }

    /**
     * 0时为空
     * 失败信息参考：
     * 1.征管有回执结果，不能撤销
     * 2.纳税人识别号与申领序号不匹配
     * 3.无申领序号对应申请记录
     * 4.核心征管正在处理中，不允许撤销
     * 5.根据纳税人识别号,申领序号未查
     */
    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

    }
}
