package com.xforceplus.micro.tax.cherry.contract.model.vatv2;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.BaseResponseDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.terminal.TerminalDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 发票领购
 *
 * @author zhouwen
 * @date 2020-04-02
 */
public class InvoicePurchaseMessage {

    @Data
    public static class Request {

        /**
         * 终端服务器信息
         */
        private TerminalDto terminalDto;

        /**
         * 发票类型
         */
        private String invoiceType;

        /**
         * 发票领购明细
         */
        private List<InvoicePurchaseDetail> invoicePurchaseDetailList;
    }

    @Data
    public static class InvoicePurchaseDetail {

        /**
         * 发票代码
         */
        private String invoiceCode;

        /**
         * 起始发票号码
         */
        private String startInvoiceNo;

        /**
         * 终止发票号码
         */
        private String endInvoiceNo;

        /**
         * 发票份数
         */
        private String count;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

    }
}
