package com.xforceplus.micro.tax.cherry.contract.model.vatv2;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.BaseResponseDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.makeinvoice.InvoiceDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.makeinvoice.PreInvoiceDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.terminal.TerminalDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * VAT发票开具 消息
 *
 * @author Bobo
 * @create 2020/3/9 15:02
 * @since 1.0.0
 */
public class MakeInvoiceMessage {

    @Data
    public static class Request {

        /**
         * 开票终端信息
         */
        private TerminalDto terminalInfo;

        /**
         * 预制发票信息
         */
        private PreInvoiceDto preInvoice;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private MakeInvoiceMessage.Response.Result result = new MakeInvoiceMessage.Response.Result();

        @Data
        public class Result {

            /**
             * 开票终端信息
             */
            private TerminalDto terminalInfo;

            /**
             * 发票信息
             */
            private InvoiceDto invoice;
        }
    }
}
