package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 明细信息
 */
@ApiModel(description = "明细信息")

@JsonInclude(NON_NULL)
public class GeneratePDFRedDetailInfo {
  @JsonProperty("cargoName")
  private String cargoName = null;

  @JsonProperty("quantity")
  private String quantity = null;

  @JsonProperty("unitPrice")
  private String unitPrice = null;

  @JsonProperty("amountWithoutTax")
  private String amountWithoutTax = null;

  @JsonProperty("taxRate")
  private String taxRate = null;

  @JsonProperty("taxAmount")
  private String taxAmount = null;

  @JsonIgnore
  public GeneratePDFRedDetailInfo cargoName(String cargoName) {
    this.cargoName = cargoName;
    return this;
  }

   /**
   * 货物或应税劳务名称
   * @return cargoName
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "货物或应税劳务名称")
  public String getCargoName() {
    return cargoName;
  }

  public void setCargoName(String cargoName) {
    this.cargoName = cargoName;
  }

  @JsonIgnore
  public GeneratePDFRedDetailInfo quantity(String quantity) {
    this.quantity = quantity;
    return this;
  }

   /**
   * 数量(支持小数点后8位)
   * @return quantity
  **/


  @ApiModelProperty(value = "数量(支持小数点后8位)")
  public String getQuantity() {
    return quantity;
  }

  public void setQuantity(String quantity) {
    this.quantity = quantity;
  }

  @JsonIgnore
  public GeneratePDFRedDetailInfo unitPrice(String unitPrice) {
    this.unitPrice = unitPrice;
    return this;
  }

   /**
   * 单价(支持小数点后8位)
   * @return unitPrice
  **/


  @ApiModelProperty(value = "单价(支持小数点后8位)")
  public String getUnitPrice() {
    return unitPrice;
  }

  public void setUnitPrice(String unitPrice) {
    this.unitPrice = unitPrice;
  }

  @JsonIgnore
  public GeneratePDFRedDetailInfo amountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额(支持小数点后2位)
   * @return amountWithoutTax
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "不含税金额(支持小数点后2位)")
  public String getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public GeneratePDFRedDetailInfo taxRate(String taxRate) {
    this.taxRate = taxRate;
    return this;
  }

   /**
   * 税率(示例，16%传0.16)
   * @return taxRate
  **/


  @ApiModelProperty(value = "税率(示例，16%传0.16)")
  public String getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(String taxRate) {
    this.taxRate = taxRate;
  }

  @JsonIgnore
  public GeneratePDFRedDetailInfo taxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额(支持小数点后2位)
   * @return taxAmount
  **/


  @ApiModelProperty(value = "税额(支持小数点后2位)")
  public String getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GeneratePDFRedDetailInfo generatePDFRedDetailInfo = (GeneratePDFRedDetailInfo) o;
    return Objects.equals(this.cargoName, generatePDFRedDetailInfo.cargoName) &&
        Objects.equals(this.quantity, generatePDFRedDetailInfo.quantity) &&
        Objects.equals(this.unitPrice, generatePDFRedDetailInfo.unitPrice) &&
        Objects.equals(this.amountWithoutTax, generatePDFRedDetailInfo.amountWithoutTax) &&
        Objects.equals(this.taxRate, generatePDFRedDetailInfo.taxRate) &&
        Objects.equals(this.taxAmount, generatePDFRedDetailInfo.taxAmount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(cargoName, quantity, unitPrice, amountWithoutTax, taxRate, taxAmount);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GeneratePDFRedDetailInfo {\n");
    
    sb.append("    cargoName: ").append(toIndentedString(cargoName)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    unitPrice: ").append(toIndentedString(unitPrice)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    taxRate: ").append(toIndentedString(taxRate)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
