package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.cherry.contract.model.ElectronicInvoiceInfo;
import com.xforceplus.micro.tax.cherry.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * GeneratePDFRequest
 */

@JsonInclude(NON_NULL)
public class GeneratePDFRequest {
  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("electronicInvoiceInfo")
  private ElectronicInvoiceInfo electronicInvoiceInfo = null;

  @JsonIgnore
  public GeneratePDFRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public GeneratePDFRequest electronicInvoiceInfo(ElectronicInvoiceInfo electronicInvoiceInfo) {
    this.electronicInvoiceInfo = electronicInvoiceInfo;
    return this;
  }

   /**
   * 电子发票信息
   * @return electronicInvoiceInfo
  **/
  @NotNull

  @Valid

  @ApiModelProperty(required = true, value = "电子发票信息")
  public ElectronicInvoiceInfo getElectronicInvoiceInfo() {
    return electronicInvoiceInfo;
  }

  public void setElectronicInvoiceInfo(ElectronicInvoiceInfo electronicInvoiceInfo) {
    this.electronicInvoiceInfo = electronicInvoiceInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GeneratePDFRequest generatePDFRequest = (GeneratePDFRequest) o;
    return Objects.equals(this.head, generatePDFRequest.head) &&
        Objects.equals(this.electronicInvoiceInfo, generatePDFRequest.electronicInvoiceInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, electronicInvoiceInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GeneratePDFRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    electronicInvoiceInfo: ").append(toIndentedString(electronicInvoiceInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
