package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.cherry.contract.model.InvoicePrintInfo;
import com.xforceplus.micro.tax.cherry.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * GeneratePrintPDFRequest
 */

@JsonInclude(NON_NULL)
public class GeneratePrintPDFRequest {
  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("invoicePrintInfo")
  private InvoicePrintInfo invoicePrintInfo = null;

  @JsonIgnore
  public GeneratePrintPDFRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public GeneratePrintPDFRequest invoicePrintInfo(InvoicePrintInfo invoicePrintInfo) {
    this.invoicePrintInfo = invoicePrintInfo;
    return this;
  }

   /**
   * 待打印发票PDF发票信息
   * @return invoicePrintInfo
  **/
  @NotNull

  @Valid

  @ApiModelProperty(required = true, value = "待打印发票PDF发票信息")
  public InvoicePrintInfo getInvoicePrintInfo() {
    return invoicePrintInfo;
  }

  public void setInvoicePrintInfo(InvoicePrintInfo invoicePrintInfo) {
    this.invoicePrintInfo = invoicePrintInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GeneratePrintPDFRequest generatePrintPDFRequest = (GeneratePrintPDFRequest) o;
    return Objects.equals(this.head, generatePrintPDFRequest.head) &&
        Objects.equals(this.invoicePrintInfo, generatePrintPDFRequest.invoicePrintInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, invoicePrintInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GeneratePrintPDFRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    invoicePrintInfo: ").append(toIndentedString(invoicePrintInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
