package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.cherry.contract.model.ResponseHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * ReceiveDispatcherResponse
 */

@JsonInclude(NON_NULL)
public class ReceiveDispatcherResponse {
  @JsonProperty("head")
  private ResponseHead head = null;

  @JsonIgnore
  public ReceiveDispatcherResponse head(ResponseHead head) {
    this.head = head;
    return this;
  }

   /**
   * 发票领购信息分发响应
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "发票领购信息分发响应")
  public ResponseHead getHead() {
    return head;
  }

  public void setHead(ResponseHead head) {
    this.head = head;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ReceiveDispatcherResponse receiveDispatcherResponse = (ReceiveDispatcherResponse) o;
    return Objects.equals(this.head, receiveDispatcherResponse.head);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ReceiveDispatcherResponse {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
