package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 红字信息表申请
 */
@ApiModel(description = "红字信息表申请")

@JsonInclude(NON_NULL)
public class RedApplyInfo {
  @JsonProperty("requestSerialNo")
  private String requestSerialNo = null;

  @JsonProperty("pid")
  private String pid = null;

  @JsonProperty("cloud")
  private String cloud = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("machineCode")
  private String machineCode = null;

  @JsonProperty("applicationReason")
  private String applicationReason = null;

  @JsonProperty("applicantName")
  private String applicantName = null;

  @JsonProperty("applicationOrganName")
  private String applicationOrganName = null;

  @JsonProperty("contactInformation")
  private String contactInformation = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("purchaseTaxNo")
  private String purchaseTaxNo = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonIgnore
  public RedApplyInfo requestSerialNo(String requestSerialNo) {
    this.requestSerialNo = requestSerialNo;
    return this;
  }

   /**
   * 请求流水号,唯一标志
   * @return requestSerialNo
  **/


  @ApiModelProperty(value = "请求流水号,唯一标志")
  public String getRequestSerialNo() {
    return requestSerialNo;
  }

  public void setRequestSerialNo(String requestSerialNo) {
    this.requestSerialNo = requestSerialNo;
  }

  @JsonIgnore
  public RedApplyInfo pid(String pid) {
    this.pid = pid;
    return this;
  }

   /**
   * pid
   * @return pid
  **/


  @ApiModelProperty(value = "pid")
  public String getPid() {
    return pid;
  }

  public void setPid(String pid) {
    this.pid = pid;
  }

  @JsonIgnore
  public RedApplyInfo cloud(String cloud) {
    this.cloud = cloud;
    return this;
  }

   /**
   * 云服务[ac-阿里云提供服务 tc-腾讯云提供服务]
   * @return cloud
  **/


  @ApiModelProperty(value = "云服务[ac-阿里云提供服务 tc-腾讯云提供服务]")
  public String getCloud() {
    return cloud;
  }

  public void setCloud(String cloud) {
    this.cloud = cloud;
  }

  @JsonIgnore
  public RedApplyInfo companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 申请公司税号
   * @return companyTaxNo
  **/


  @ApiModelProperty(value = "申请公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public RedApplyInfo invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/


  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public RedApplyInfo invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/


  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public RedApplyInfo machineCode(String machineCode) {
    this.machineCode = machineCode;
    return this;
  }

   /**
   * 开票终端代码
   * @return machineCode
  **/


  @ApiModelProperty(value = "开票终端代码")
  public String getMachineCode() {
    return machineCode;
  }

  public void setMachineCode(String machineCode) {
    this.machineCode = machineCode;
  }

  @JsonIgnore
  public RedApplyInfo applicationReason(String applicationReason) {
    this.applicationReason = applicationReason;
    return this;
  }

   /**
   * 1-购方未抵扣申请  2-销方申请
   * @return applicationReason
  **/


  @ApiModelProperty(value = "1-购方未抵扣申请  2-销方申请")
  public String getApplicationReason() {
    return applicationReason;
  }

  public void setApplicationReason(String applicationReason) {
    this.applicationReason = applicationReason;
  }

  @JsonIgnore
  public RedApplyInfo applicantName(String applicantName) {
    this.applicantName = applicantName;
    return this;
  }

   /**
   * 申请人名称
   * @return applicantName
  **/


  @ApiModelProperty(value = "申请人名称")
  public String getApplicantName() {
    return applicantName;
  }

  public void setApplicantName(String applicantName) {
    this.applicantName = applicantName;
  }

  @JsonIgnore
  public RedApplyInfo applicationOrganName(String applicationOrganName) {
    this.applicationOrganName = applicationOrganName;
    return this;
  }

   /**
   * 申请机关名称
   * @return applicationOrganName
  **/


  @ApiModelProperty(value = "申请机关名称")
  public String getApplicationOrganName() {
    return applicationOrganName;
  }

  public void setApplicationOrganName(String applicationOrganName) {
    this.applicationOrganName = applicationOrganName;
  }

  @JsonIgnore
  public RedApplyInfo contactInformation(String contactInformation) {
    this.contactInformation = contactInformation;
    return this;
  }

   /**
   * 联系方式
   * @return contactInformation
  **/


  @ApiModelProperty(value = "联系方式")
  public String getContactInformation() {
    return contactInformation;
  }

  public void setContactInformation(String contactInformation) {
    this.contactInformation = contactInformation;
  }

  @JsonIgnore
  public RedApplyInfo purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方名称
   * @return purchaserName
  **/


  @ApiModelProperty(value = "购方名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public RedApplyInfo purchaseTaxNo(String purchaseTaxNo) {
    this.purchaseTaxNo = purchaseTaxNo;
    return this;
  }

   /**
   * 购方税号
   * @return purchaseTaxNo
  **/


  @ApiModelProperty(value = "购方税号")
  public String getPurchaseTaxNo() {
    return purchaseTaxNo;
  }

  public void setPurchaseTaxNo(String purchaseTaxNo) {
    this.purchaseTaxNo = purchaseTaxNo;
  }

  @JsonIgnore
  public RedApplyInfo sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

   /**
   * 销方名称
   * @return sellerName
  **/


  @ApiModelProperty(value = "销方名称")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public RedApplyInfo sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 销方税号
   * @return sellerTaxNo
  **/


  @ApiModelProperty(value = "销方税号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RedApplyInfo redApplyInfo = (RedApplyInfo) o;
    return Objects.equals(this.requestSerialNo, redApplyInfo.requestSerialNo) &&
        Objects.equals(this.pid, redApplyInfo.pid) &&
        Objects.equals(this.cloud, redApplyInfo.cloud) &&
        Objects.equals(this.companyTaxNo, redApplyInfo.companyTaxNo) &&
        Objects.equals(this.invoiceCode, redApplyInfo.invoiceCode) &&
        Objects.equals(this.invoiceNo, redApplyInfo.invoiceNo) &&
        Objects.equals(this.machineCode, redApplyInfo.machineCode) &&
        Objects.equals(this.applicationReason, redApplyInfo.applicationReason) &&
        Objects.equals(this.applicantName, redApplyInfo.applicantName) &&
        Objects.equals(this.applicationOrganName, redApplyInfo.applicationOrganName) &&
        Objects.equals(this.contactInformation, redApplyInfo.contactInformation) &&
        Objects.equals(this.purchaserName, redApplyInfo.purchaserName) &&
        Objects.equals(this.purchaseTaxNo, redApplyInfo.purchaseTaxNo) &&
        Objects.equals(this.sellerName, redApplyInfo.sellerName) &&
        Objects.equals(this.sellerTaxNo, redApplyInfo.sellerTaxNo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(requestSerialNo, pid, cloud, companyTaxNo, invoiceCode, invoiceNo, machineCode, applicationReason, applicantName, applicationOrganName, contactInformation, purchaserName, purchaseTaxNo, sellerName, sellerTaxNo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RedApplyInfo {\n");
    
    sb.append("    requestSerialNo: ").append(toIndentedString(requestSerialNo)).append("\n");
    sb.append("    pid: ").append(toIndentedString(pid)).append("\n");
    sb.append("    cloud: ").append(toIndentedString(cloud)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    machineCode: ").append(toIndentedString(machineCode)).append("\n");
    sb.append("    applicationReason: ").append(toIndentedString(applicationReason)).append("\n");
    sb.append("    applicantName: ").append(toIndentedString(applicantName)).append("\n");
    sb.append("    applicationOrganName: ").append(toIndentedString(applicationOrganName)).append("\n");
    sb.append("    contactInformation: ").append(toIndentedString(contactInformation)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    purchaseTaxNo: ").append(toIndentedString(purchaseTaxNo)).append("\n");
    sb.append("    sellerName: ").append(toIndentedString(sellerName)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
