package com.xforceplus.micro.tax.cherry.contract.model.vatv2;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.BaseResponseDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.terminal.TerminalDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

public class DistributeQueryMessage {

    @Data
    public static class Request {

        /**
         * 终端服务器信息
         */
        private TerminalDto terminalDto;

        /**
         * 发票类型
         */
        private String invoiceType;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {
        private Result result;

        @Data
        public static class Result {

            private List<Distribute> unDistributeList;

            @Data
            public static class Distribute {

                /**
                 * 发票代码
                 */
                private String invoiceCode;

                /**
                 * 起始号码
                 */
                private String startInvoiceNo;

                /**
                 * 终止号码
                 */
                private String endInvoiceNo;

                /**
                 * 发票份数
                 */
                private String invoiceCount;

                /**
                 * 剩余数量
                 */
                private String remainCount;
            }
        }
    }
}
