package com.xforceplus.micro.tax.cherry.contract.model.vatv2;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.BaseResponseDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.device.DeviceDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author zhouwen
 * @date 2020-04-01
 */
public class InvoiceApplyQueryMessage {

    @Data
    public static class Request {

        /**
         * 设备服务器信息
         */
        private DeviceDto deviceDto;

        /**
         * 税号
         */
        private String taxCode;

        /**
         * 发票类型代码
         */
        private String invoiceType;

        /**
         * 申领起始时间(yyyy-MM-dd)
         */
        private String startApplyTime;

        /**
         * 申领截止时间(yyyy-MM-dd)
         */
        private String endApplyTime;

        /**
         * 申领序号
         */
        private String applySeq;

        /**
         * 处理状态：1-成功；2-失败；0-申领中
         */
        private String status;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        /**
         * 结果信息
         */
        private InvoiceApplyQueryMessage.Result result = new InvoiceApplyQueryMessage.Result();

    }

    @Data
    public static class Result {

        /**
         * 纳税人识别号
         */
        private String taxCode;

        /**
         * 虚拟设备号
         */
        private String deviceNo;

        /**
         * 申领结果信息
         */
        private List<ApplyDetail> applyDetailList;
    }

    /**
     * 申领明细
     */
    @Data
    public static class ApplyDetail {

        /**
         * 发票类型代码
         */
        private String invoiceType;

        /**
         * 发票种类代码
         */
        private String invoiceKind;

        /**
         * 申领序号
         */
        private String applySeq;

        /**
         * 申领数量
         */
        private String applyCount;

        /**
         * 申领时间
         */
        private String applyTime;

        /**
         * 处理状态
         */
        private String processCode;

        /**
         * 处理信息
         */
        private String processMessage;

        /**
         * 处理时间
         */
        private String processTime;

        /**
         * 预申领编号
         */
        private String preApplyCode;

        /**
         * 结果确认标识
         */
        private String resultFlag;

        /**
         * 申领发票明细
         */
        private List<InvoiceApplyDetail> invoiceApplyDetailList;
    }

    @Data
    public static class InvoiceApplyDetail {

        /**
         * 发票代码
         */
        private String invoiceCode;

        /**
         * 起始发票号码
         */
        private String startInvoiceNo;

        /**
         * 终止发票号码
         */
        private String endInvoiceNo;

        /**
         * 发票份数
         */
        private String invoiceCount;
    }
}
