package com.xforceplus.micro.tax.cherry.contract.model.vatv2;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.BaseResponseDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.device.DeviceDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

public class InvoicePurchaseQueryMessage {
    @Data
    public static class Request {

        /**
         * 设备服务器信息
         */
        private DeviceDto deviceDto;

        /**
         * 发票类型
         */
        private String invoiceType;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        /**
         * 处理结果
         */
        private Result result;

        @Data
        public static class Result {

            /**
             * 领购结果列表
             */
            private List<PurchaseResult> purchaseResultList;


            @Data
            public static class PurchaseResult {
                /**
                 * 发票类型
                 */
                private String invoiceType;

                /**
                 * 发票代码
                 */
                private String invoiceCode;

                /**
                 * 起始发票号码
                 */
                private String startInvoiceNo;

                /**
                 * 终止发票号码
                 */
                private String endInvoiceNo;

                /**
                 * 发票份数
                 */
                private String invoiceCount;

                /**
                 * 领票状态
                 */
                private String purchaseStatus;
            }
        }
    }
}
