package com.xforceplus.micro.tax.cherry.contract.model.vatv2;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.BaseResponseDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.terminal.TerminalDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

public class NextInvoiceNoMessage {

    @Data
    public static class Request {

        /**
         * 终端信息
         */
        private TerminalDto terminalInfo;

        /**
         * 发票类型(ce-电票,s-专票, c-普票)
         */
        private String invoiceType;
    }


    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        /**
         * 结果信息
         */
        private Result result;
    }

    @Data
    public static class Result {

        /**
         * 发票类型
         */
        private String invoiceType;

        /**
         * 发票代码
         */
        private String invoiceCode;

        /**
         * 发票号码
         */
        private String invoiceNo;
    }
}

