package com.xforceplus.micro.tax.cherry.contract.model.vatv2;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.BaseResponseDto;
import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.terminal.TerminalDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 抄报结果
 *
 * @author Bobo
 * @create 2020/4/3 21:46
 * @since 1.0.0
 */
public class SumDataResMessage {

    @Data
    public static class Request {

        /**
         * 终端信息
         */
        private TerminalDto terminalInfo;

        /**
         * 发票类型(ce-电票,s-专票, c-普票)
         */
        private String invoiceType;
    }


    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        /**
         * 结果信息
         */
        private SumDataResMessage.Result result;
    }

    @Data
    public static class Result {

        /**
         * 虚拟设备号
         */
        private String deviceNo;

        /**
         * 纳税人识别号
         */
        private String taxCode;

        /**
         * 已抄数据所属月份
         */
        private String reportMonth;

        /**
         * 抄报完成的时间
         */
        private String reportTime;
    }

}
