package com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.invoice.detail;

import lombok.Data;

/**
 * 税收信息
 *
 * @author Bobo
 * @create 2020/3/7 16:13
 * @since 1.0.0
 */
@Data
public class TaxDto {

    /**
     * 税率(例如，16%传0.16)
     */
    private String taxRate;

    /**
     * 是否享受税收优惠政策
     */
    private boolean preferentialTax;

    /**
     * 享受税收优惠政策内容。
     * <p>
     * 0税率时： 根据 zeroTax 的情况，分别填： 免税 / 不征税 / 普通0税率
     */
    private String taxPolicy;

    /**
     * 零税率标志
     * <p>
     * 非0税率: 空
     * <p>
     * 1-出口免税和其他免税优惠政策, 2-不征税 ,3-普通零税率
     */
    private String zeroTax;
}
