package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 金额信息
 */
@ApiModel(description = "金额信息")

@JsonInclude(NON_NULL)
public class InvoiceAmountInfo {
  @JsonProperty("totalAmountWithTax")
  private String totalAmountWithTax = null;

  @JsonProperty("totalAmountWithoutTax")
  private String totalAmountWithoutTax = null;

  @JsonProperty("totalTaxAmount")
  private String totalTaxAmount = null;

  @JsonIgnore
  public InvoiceAmountInfo totalAmountWithTax(String totalAmountWithTax) {
    this.totalAmountWithTax = totalAmountWithTax;
    return this;
  }

   /**
   * 合计含税金额(支持小数点后2位)
   * @return totalAmountWithTax
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "合计含税金额(支持小数点后2位)")
  public String getTotalAmountWithTax() {
    return totalAmountWithTax;
  }

  public void setTotalAmountWithTax(String totalAmountWithTax) {
    this.totalAmountWithTax = totalAmountWithTax;
  }

  @JsonIgnore
  public InvoiceAmountInfo totalAmountWithoutTax(String totalAmountWithoutTax) {
    this.totalAmountWithoutTax = totalAmountWithoutTax;
    return this;
  }

   /**
   * 合计不含税金额(支持小数点后2位)
   * @return totalAmountWithoutTax
  **/
  @NotNull


  @ApiModelProperty(required = true, value = "合计不含税金额(支持小数点后2位)")
  public String getTotalAmountWithoutTax() {
    return totalAmountWithoutTax;
  }

  public void setTotalAmountWithoutTax(String totalAmountWithoutTax) {
    this.totalAmountWithoutTax = totalAmountWithoutTax;
  }

  @JsonIgnore
  public InvoiceAmountInfo totalTaxAmount(String totalTaxAmount) {
    this.totalTaxAmount = totalTaxAmount;
    return this;
  }

   /**
   * 合计税额(支持小数点后2位)
   * @return totalTaxAmount
  **/


  @ApiModelProperty(value = "合计税额(支持小数点后2位)")
  public String getTotalTaxAmount() {
    return totalTaxAmount;
  }

  public void setTotalTaxAmount(String totalTaxAmount) {
    this.totalTaxAmount = totalTaxAmount;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InvoiceAmountInfo invoiceAmountInfo = (InvoiceAmountInfo) o;
    return Objects.equals(this.totalAmountWithTax, invoiceAmountInfo.totalAmountWithTax) &&
        Objects.equals(this.totalAmountWithoutTax, invoiceAmountInfo.totalAmountWithoutTax) &&
        Objects.equals(this.totalTaxAmount, invoiceAmountInfo.totalTaxAmount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(totalAmountWithTax, totalAmountWithoutTax, totalTaxAmount);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InvoiceAmountInfo {\n");
    
    sb.append("    totalAmountWithTax: ").append(toIndentedString(totalAmountWithTax)).append("\n");
    sb.append("    totalAmountWithoutTax: ").append(toIndentedString(totalAmountWithoutTax)).append("\n");
    sb.append("    totalTaxAmount: ").append(toIndentedString(totalTaxAmount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
