package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * 红字信息表明细
 */
@ApiModel(description = "红字信息表明细")

@JsonInclude(NON_NULL)
public class RedNotificationDetail {
  @JsonProperty("itemName")
  private String itemName = null;

  @JsonProperty("unit")
  private String unit = null;

  @JsonProperty("unitPrice")
  private String unitPrice = null;

  @JsonProperty("taxRate")
  private String taxRate = null;

  @JsonProperty("itemSpec")
  private String itemSpec = null;

  @JsonProperty("isMutiRate")
  private String isMutiRate = null;

  @JsonProperty("quantity")
  private String quantity = null;

  @JsonProperty("amountWithoutTax")
  private String amountWithoutTax = null;

  @JsonProperty("amountWithTax")
  private String amountWithTax = null;

  @JsonProperty("taxAmount")
  private String taxAmount = null;

  @JsonProperty("priceMethod")
  private String priceMethod = null;

  @JsonProperty("goodsTaxNo")
  private String goodsTaxNo = null;

  @JsonProperty("corpGoodsNo")
  private String corpGoodsNo = null;

  @JsonProperty("taxPer")
  private String taxPer = null;

  @JsonProperty("taxPerCon")
  private String taxPerCon = null;

  @JsonProperty("zeroTax")
  private String zeroTax = null;

  @JsonIgnore
  public RedNotificationDetail itemName(String itemName) {
    this.itemName = itemName;
    return this;
  }

   /**
   * 货物名称
   * @return itemName
  **/


  @ApiModelProperty(value = "货物名称")
  public String getItemName() {
    return itemName;
  }

  public void setItemName(String itemName) {
    this.itemName = itemName;
  }

  @JsonIgnore
  public RedNotificationDetail unit(String unit) {
    this.unit = unit;
    return this;
  }

   /**
   * 货物单位
   * @return unit
  **/


  @ApiModelProperty(value = "货物单位")
  public String getUnit() {
    return unit;
  }

  public void setUnit(String unit) {
    this.unit = unit;
  }

  @JsonIgnore
  public RedNotificationDetail unitPrice(String unitPrice) {
    this.unitPrice = unitPrice;
    return this;
  }

   /**
   * 货物价格
   * @return unitPrice
  **/


  @ApiModelProperty(value = "货物价格")
  public String getUnitPrice() {
    return unitPrice;
  }

  public void setUnitPrice(String unitPrice) {
    this.unitPrice = unitPrice;
  }

  @JsonIgnore
  public RedNotificationDetail taxRate(String taxRate) {
    this.taxRate = taxRate;
    return this;
  }

   /**
   * 货物税率
   * @return taxRate
  **/


  @ApiModelProperty(value = "货物税率")
  public String getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(String taxRate) {
    this.taxRate = taxRate;
  }

  @JsonIgnore
  public RedNotificationDetail itemSpec(String itemSpec) {
    this.itemSpec = itemSpec;
    return this;
  }

   /**
   * 规格型号
   * @return itemSpec
  **/


  @ApiModelProperty(value = "规格型号")
  public String getItemSpec() {
    return itemSpec;
  }

  public void setItemSpec(String itemSpec) {
    this.itemSpec = itemSpec;
  }

  @JsonIgnore
  public RedNotificationDetail isMutiRate(String isMutiRate) {
    this.isMutiRate = isMutiRate;
    return this;
  }

   /**
   * 多税率标识 0-一票一税率  1-一票多税率
   * @return isMutiRate
  **/


  @ApiModelProperty(value = "多税率标识 0-一票一税率  1-一票多税率")
  public String getIsMutiRate() {
    return isMutiRate;
  }

  public void setIsMutiRate(String isMutiRate) {
    this.isMutiRate = isMutiRate;
  }

  @JsonIgnore
  public RedNotificationDetail quantity(String quantity) {
    this.quantity = quantity;
    return this;
  }

   /**
   * 货物数量
   * @return quantity
  **/


  @ApiModelProperty(value = "货物数量")
  public String getQuantity() {
    return quantity;
  }

  public void setQuantity(String quantity) {
    this.quantity = quantity;
  }

  @JsonIgnore
  public RedNotificationDetail amountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额
   * @return amountWithoutTax
  **/


  @ApiModelProperty(value = "不含税金额")
  public String getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public RedNotificationDetail amountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 含税金额
   * @return amountWithTax
  **/


  @ApiModelProperty(value = "含税金额")
  public String getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public RedNotificationDetail taxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/


  @ApiModelProperty(value = "税额")
  public String getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public RedNotificationDetail priceMethod(String priceMethod) {
    this.priceMethod = priceMethod;
    return this;
  }

   /**
   * 含税标识 0-不含税 1-含税
   * @return priceMethod
  **/


  @ApiModelProperty(value = "含税标识 0-不含税 1-含税")
  public String getPriceMethod() {
    return priceMethod;
  }

  public void setPriceMethod(String priceMethod) {
    this.priceMethod = priceMethod;
  }

  @JsonIgnore
  public RedNotificationDetail goodsTaxNo(String goodsTaxNo) {
    this.goodsTaxNo = goodsTaxNo;
    return this;
  }

   /**
   * 税收分类编码
   * @return goodsTaxNo
  **/


  @ApiModelProperty(value = "税收分类编码")
  public String getGoodsTaxNo() {
    return goodsTaxNo;
  }

  public void setGoodsTaxNo(String goodsTaxNo) {
    this.goodsTaxNo = goodsTaxNo;
  }

  @JsonIgnore
  public RedNotificationDetail corpGoodsNo(String corpGoodsNo) {
    this.corpGoodsNo = corpGoodsNo;
    return this;
  }

   /**
   * 企业自编码
   * @return corpGoodsNo
  **/


  @ApiModelProperty(value = "企业自编码")
  public String getCorpGoodsNo() {
    return corpGoodsNo;
  }

  public void setCorpGoodsNo(String corpGoodsNo) {
    this.corpGoodsNo = corpGoodsNo;
  }

  @JsonIgnore
  public RedNotificationDetail taxPer(String taxPer) {
    this.taxPer = taxPer;
    return this;
  }

   /**
   * 优惠政策标识
   * @return taxPer
  **/


  @ApiModelProperty(value = "优惠政策标识")
  public String getTaxPer() {
    return taxPer;
  }

  public void setTaxPer(String taxPer) {
    this.taxPer = taxPer;
  }

  @JsonIgnore
  public RedNotificationDetail taxPerCon(String taxPerCon) {
    this.taxPerCon = taxPerCon;
    return this;
  }

   /**
   * 优惠政策内容
   * @return taxPerCon
  **/


  @ApiModelProperty(value = "优惠政策内容")
  public String getTaxPerCon() {
    return taxPerCon;
  }

  public void setTaxPerCon(String taxPerCon) {
    this.taxPerCon = taxPerCon;
  }

  @JsonIgnore
  public RedNotificationDetail zeroTax(String zeroTax) {
    this.zeroTax = zeroTax;
    return this;
  }

   /**
   * 零税率标识
   * @return zeroTax
  **/


  @ApiModelProperty(value = "零税率标识")
  public String getZeroTax() {
    return zeroTax;
  }

  public void setZeroTax(String zeroTax) {
    this.zeroTax = zeroTax;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RedNotificationDetail redNotificationDetail = (RedNotificationDetail) o;
    return Objects.equals(this.itemName, redNotificationDetail.itemName) &&
        Objects.equals(this.unit, redNotificationDetail.unit) &&
        Objects.equals(this.unitPrice, redNotificationDetail.unitPrice) &&
        Objects.equals(this.taxRate, redNotificationDetail.taxRate) &&
        Objects.equals(this.itemSpec, redNotificationDetail.itemSpec) &&
        Objects.equals(this.isMutiRate, redNotificationDetail.isMutiRate) &&
        Objects.equals(this.quantity, redNotificationDetail.quantity) &&
        Objects.equals(this.amountWithoutTax, redNotificationDetail.amountWithoutTax) &&
        Objects.equals(this.amountWithTax, redNotificationDetail.amountWithTax) &&
        Objects.equals(this.taxAmount, redNotificationDetail.taxAmount) &&
        Objects.equals(this.priceMethod, redNotificationDetail.priceMethod) &&
        Objects.equals(this.goodsTaxNo, redNotificationDetail.goodsTaxNo) &&
        Objects.equals(this.corpGoodsNo, redNotificationDetail.corpGoodsNo) &&
        Objects.equals(this.taxPer, redNotificationDetail.taxPer) &&
        Objects.equals(this.taxPerCon, redNotificationDetail.taxPerCon) &&
        Objects.equals(this.zeroTax, redNotificationDetail.zeroTax);
  }

  @Override
  public int hashCode() {
    return Objects.hash(itemName, unit, unitPrice, taxRate, itemSpec, isMutiRate, quantity, amountWithoutTax, amountWithTax, taxAmount, priceMethod, goodsTaxNo, corpGoodsNo, taxPer, taxPerCon, zeroTax);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RedNotificationDetail {\n");
    
    sb.append("    itemName: ").append(toIndentedString(itemName)).append("\n");
    sb.append("    unit: ").append(toIndentedString(unit)).append("\n");
    sb.append("    unitPrice: ").append(toIndentedString(unitPrice)).append("\n");
    sb.append("    taxRate: ").append(toIndentedString(taxRate)).append("\n");
    sb.append("    itemSpec: ").append(toIndentedString(itemSpec)).append("\n");
    sb.append("    isMutiRate: ").append(toIndentedString(isMutiRate)).append("\n");
    sb.append("    quantity: ").append(toIndentedString(quantity)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    priceMethod: ").append(toIndentedString(priceMethod)).append("\n");
    sb.append("    goodsTaxNo: ").append(toIndentedString(goodsTaxNo)).append("\n");
    sb.append("    corpGoodsNo: ").append(toIndentedString(corpGoodsNo)).append("\n");
    sb.append("    taxPer: ").append(toIndentedString(taxPer)).append("\n");
    sb.append("    taxPerCon: ").append(toIndentedString(taxPerCon)).append("\n");
    sb.append("    zeroTax: ").append(toIndentedString(zeroTax)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
