package com.xforceplus.micro.tax.cherry.contract.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.micro.tax.cherry.contract.model.RedSyncInfo;
import com.xforceplus.micro.tax.cherry.contract.model.RequestHead;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * RedSyncRequest
 */

@JsonInclude(NON_NULL)
public class RedSyncRequest {
  @JsonProperty("head")
  private RequestHead head = null;

  @JsonProperty("redSyncInfo")
  private RedSyncInfo redSyncInfo = null;

  @JsonIgnore
  public RedSyncRequest head(RequestHead head) {
    this.head = head;
    return this;
  }

   /**
   * 标准请求头信息
   * @return head
  **/

  @Valid

  @ApiModelProperty(value = "标准请求头信息")
  public RequestHead getHead() {
    return head;
  }

  public void setHead(RequestHead head) {
    this.head = head;
  }

  @JsonIgnore
  public RedSyncRequest redSyncInfo(RedSyncInfo redSyncInfo) {
    this.redSyncInfo = redSyncInfo;
    return this;
  }

   /**
   * 红字信息表同步信息
   * @return redSyncInfo
  **/

  @Valid

  @ApiModelProperty(value = "红字信息表同步信息")
  public RedSyncInfo getRedSyncInfo() {
    return redSyncInfo;
  }

  public void setRedSyncInfo(RedSyncInfo redSyncInfo) {
    this.redSyncInfo = redSyncInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RedSyncRequest redSyncRequest = (RedSyncRequest) o;
    return Objects.equals(this.head, redSyncRequest.head) &&
        Objects.equals(this.redSyncInfo, redSyncRequest.redSyncInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(head, redSyncInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RedSyncRequest {\n");
    
    sb.append("    head: ").append(toIndentedString(head)).append("\n");
    sb.append("    redSyncInfo: ").append(toIndentedString(redSyncInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
