package com.xforceplus.micro.tax.cherry.contract.model.vatv2;

import com.xforceplus.micro.tax.cherry.contract.model.vatv2.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * OFD转换为图片
 *
 * @author yhx
 */
public class OfdConvertImgMessage {

    @Data
    public static class Request {

        /**
         * 发票代码
         */
        private String invoiceCode;

        /**
         * 发票号码
         */
        private String invoiceNo;

        /**
         * 图片倍率(默认5倍)
         */
        private Float ratio;

        /**
         * 图片格式（支持：png,jpg,tiff；默认png）
         */
        private String imageFormat;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {
        private Result result;

        @Data
        public static class Result {

            /**
             * 内网图片O地址
             */
            private String internalImageUrl;

            /**
             * 图片地址
             */
            private String imageUrl;
        }
    }
}
